/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;

public class ReplicaTeleportMahoujinEntity
extends Entity {
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_CIRCLE_SIZE";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_GOAL_X = "MAHOUTSUKAI_GOAL_X";
    private static final String TAG_GOAL_Y = "MAHOUTSUKAI_GOAL_Y";
    private static final String TAG_GOAL_Z = "MAHOUTSUKAI_GOAL_Z";
    private static final String TAG_GOAL_DIM = "MAHOUTSUKAI_GOAL_DIM";
    private static final String TAG_FRIENDLY_ONLY = "MAHOUTSUKAI_FRIENDLY_ONLY";
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final EntityDataAccessor<Float> CIRCLE_SIZE = SynchedEntityData.defineId(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.defineId(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.defineId(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> GOAL_X = SynchedEntityData.defineId(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> GOAL_Y = SynchedEntityData.defineId(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> GOAL_Z = SynchedEntityData.defineId(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<String> GOAL_DIM = SynchedEntityData.defineId(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Boolean> FRIENDLY_ONLY = SynchedEntityData.defineId(ReplicaTeleportMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int casterUUID = 0;
    public boolean doTeleport = true;
    public static final String entityName = "replica_teleport_mahoujin_entity";

    public ReplicaTeleportMahoujinEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public ReplicaTeleportMahoujinEntity(Level world) {
        super((EntityType)ModEntities.REPLICA_TELEPORT.get(), world);
        this.noCulling = true;
    }

    public ReplicaTeleportMahoujinEntity(Level world, LivingEntity caster, float r, float g, float b, float a, ResourceLocation dim, Vec3 goal, boolean friendly) {
        this(world);
        this.casterUUID = caster.getId();
        this.setColor(r, g, b, a);
        this.setGoal(goal);
        this.setGoalDim(dim);
        this.setFriendlyOnly(friendly);
        this.sizer(0.0f);
    }

    public ReplicaTeleportMahoujinEntity(Level world, LivingEntity caster, float r, float g, float b, float a, ResourceLocation dim, Vec3 goal, boolean friendly, boolean doTeleport) {
        this(world, caster, r, g, b, a, dim, goal, friendly);
        this.doTeleport = doTeleport;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        builder.define(LIFE, (Object)0);
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(1.0f));
        builder.define(GOAL_X, (Object)Float.valueOf(1.0f));
        builder.define(GOAL_Y, (Object)Float.valueOf(1.0f));
        builder.define(GOAL_Z, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A, (Object)Float.valueOf(0.0f));
        builder.define(GOAL_DIM, (Object)"minecraft:overworld");
        builder.define(FRIENDLY_ONLY, (Object)true);
    }

    public void tick() {
        super.tick();
        int teleportStart = MTConfig.REPLICA_TELEPORT_START_TELEPORTING;
        int teleportEnd = MTConfig.REPLICA_TELEPORT_STOP_TELEPORTING;
        int dieTime = MTConfig.REPLICA_TELEPORT_LIFE;
        float maxRadius = (float)MTConfig.REPLICA_TELEPORT_FRIEND_RANGE;
        this.setDeltaMovement(0.0, 0.0, 0.0);
        if (!this.level().isClientSide) {
            this.setLife(this.getLife() + 1);
            Entity caster = this.level().getEntity(this.casterUUID);
            if (caster == null || !caster.isAlive()) {
                this.discard();
            }
            if (this.getLife() < teleportStart && this.getCircleSize() < maxRadius) {
                this.setCircleSize(this.getCircleSize() + 2.0f * maxRadius / (float)teleportStart);
            }
            if (this.getLife() >= teleportStart && this.getLife() < teleportEnd && this.doTeleport) {
                AABB aabb = new AABB(this.getX() - (double)maxRadius, this.getY() - (double)maxRadius, this.getZ() - (double)maxRadius, this.getX() + (double)maxRadius, this.getY() + (double)maxRadius, this.getZ() + (double)maxRadius);
                List entities = this.level().getEntitiesOfClass(Entity.class, aabb);
                Vec3 goal = this.getGoal();
                ResourceLocation res = this.getGoalDim();
                boolean teleportAll = this.getFriendlyOnly();
                for (Entity e : entities) {
                    if (!(e instanceof ItemEntity) && (!(e instanceof LivingEntity) || !teleportAll && !ContractMahoujinTileEntity.isImmuneToSpell(this.level(), caster.getUUID(), e)) || !(e.position().distanceToSqr(this.position()) < (double)(maxRadius * maxRadius))) continue;
                    MahouTsukaiTeleporter.teleport(e, goal.x, goal.y, goal.z, res);
                }
            }
            if (this.getLife() > teleportEnd && this.getLife() < dieTime) {
                this.setCircleSize(Math.max(0.0f, this.getCircleSize() - 2.0f * maxRadius / (float)(dieTime - teleportEnd)));
            }
            if (this.getLife() >= dieTime) {
                this.discard();
            }
        } else {
            MahouTsukaiMod.proxy.spawnReplicaTeleportParticles(this);
        }
    }

    public boolean isPickable() {
        return false;
    }

    public void setColor(float r, float g, float b, float a) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        this.entityData.set(COLOR_A, (Object)Float.valueOf(a));
    }

    public void setGoal(Vec3 vec) {
        this.entityData.set(GOAL_X, (Object)Float.valueOf((float)vec.x));
        this.entityData.set(GOAL_Y, (Object)Float.valueOf((float)vec.y));
        this.entityData.set(GOAL_Z, (Object)Float.valueOf((float)vec.z));
    }

    public Vec3 getGoal() {
        return new Vec3((double)((Float)this.entityData.get(GOAL_X)).floatValue(), (double)((Float)this.entityData.get(GOAL_Y)).floatValue(), (double)((Float)this.entityData.get(GOAL_Z)).floatValue());
    }

    public void setFriendlyOnly(boolean b) {
        this.entityData.set(FRIENDLY_ONLY, (Object)b);
    }

    public boolean getFriendlyOnly() {
        return (Boolean)this.entityData.get(FRIENDLY_ONLY);
    }

    protected void checkInsideBlocks() {
    }

    @Nullable
    public AABB getBoundingBox() {
        return ZERO_AABB;
    }

    public float[] getColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue(), ((Float)this.entityData.get(COLOR_A)).floatValue()};
    }

    public void sizer(float s) {
        this.setCircleSize(s);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setCircleSize(compound.getFloat(TAG_CIRCLE_SIZE));
        this.setLife(compound.getInt(TAG_LIFE));
        this.setColor(compound.getFloat(TAG_COLOR_R), compound.getFloat(TAG_COLOR_G), compound.getFloat(TAG_COLOR_B), compound.getFloat(TAG_COLOR_A));
        this.setGoal(new Vec3((double)compound.getFloat(TAG_GOAL_X), (double)compound.getFloat(TAG_GOAL_Y), (double)compound.getFloat(TAG_GOAL_Z)));
        this.setGoalDim(ResourceLocation.parse((String)compound.getString(TAG_GOAL_DIM)));
        this.setFriendlyOnly(compound.getBoolean(TAG_FRIENDLY_ONLY));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat(TAG_CIRCLE_SIZE, this.getCircleSize());
        compound.putInt(TAG_LIFE, this.getLife());
        float[] colors = this.getColor();
        compound.putFloat(TAG_COLOR_R, colors[0]);
        compound.putFloat(TAG_COLOR_G, colors[1]);
        compound.putFloat(TAG_COLOR_B, colors[2]);
        compound.putFloat(TAG_COLOR_A, colors[3]);
        Vec3 goal = this.getGoal();
        compound.putFloat(TAG_GOAL_X, (float)goal.x);
        compound.putFloat(TAG_GOAL_Y, (float)goal.y);
        compound.putFloat(TAG_GOAL_Z, (float)goal.z);
        compound.putString(TAG_GOAL_DIM, this.getGoalDim().toString());
        compound.putBoolean(TAG_FRIENDLY_ONLY, this.getFriendlyOnly());
    }

    public AABB getBoundingBoxForCulling() {
        return bb;
    }

    public ResourceLocation getGoalDim() {
        return ResourceLocation.parse((String)((String)this.entityData.get(GOAL_DIM)));
    }

    public void setGoalDim(ResourceLocation dim) {
        this.entityData.set(GOAL_DIM, (Object)dim.toString());
    }

    public float getCircleSize() {
        return ((Float)this.entityData.get(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.entityData.set(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.entityData.get(LIFE);
    }

    public void setLife(int l) {
        this.entityData.set(LIFE, (Object)l);
    }
}

