/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.Bakuretsu;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.MysticStaff;
import stepsword.mahoutsukai.networking.BakuretsuPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.util.Utils;

public class MysticStaffMahoujinEntity
extends Entity {
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_ROTATION_SPEED = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_BEAM = "MAHOUTSUKAI_BEAM";
    private static final String TAG_BEAM_SIZE = "MAHOUTSUKAI_BEAM_SIZE";
    private static final String TAG_BEAM_LENGTH = "MAHOUTSUKAI_BEAM_LENGTH";
    private static final String TAG_BEAM_OFFSET = "MAHOUTSUKAI_BEAM_OFFSET";
    private static final String TAG_SHOOTING_TICKS = "MAHOUTSUKAI_SHOOTING_TICKS";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_DISTANCE = "MAHOUTSUKAI_DISTANCE";
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final int loadUpTime = 20;
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final EntityDataAccessor<Float> ROTATION_YAW = SynchedEntityData.defineId(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_ROLL = SynchedEntityData.defineId(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_PITCH = SynchedEntityData.defineId(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_SPEED = SynchedEntityData.defineId(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> CIRCLE_SIZE = SynchedEntityData.defineId(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> BEAM_SIZE = SynchedEntityData.defineId(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.defineId(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> BEAM = SynchedEntityData.defineId(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> BEAM_LENGTH = SynchedEntityData.defineId(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> BEAM_OFFSET = SynchedEntityData.defineId(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> SHOOTING_TICKS = SynchedEntityData.defineId(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.defineId(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DISTANCE = SynchedEntityData.defineId(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    Vec3 target;
    public UUID casterUUID = null;
    public static final String entityName = "mahoujin_entity";

    public MysticStaffMahoujinEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public MysticStaffMahoujinEntity(Level world) {
        super((EntityType)ModEntities.EXPLOSION_MAHOUJIN.get(), world);
        this.noCulling = true;
    }

    public MysticStaffMahoujinEntity(Level world, Player caster, boolean hasBeam, float r, float g, float b, float a) {
        this(world);
        this.casterUUID = caster.getUUID();
        this.setHasBeam(hasBeam);
        this.setColor(r, g, b, a);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_SPEED, (Object)Float.valueOf(0.0f));
        builder.define(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        builder.define(LIFE, (Object)0);
        builder.define(BEAM, (Object)false);
        builder.define(BEAM_SIZE, (Object)Float.valueOf(0.0f));
        builder.define(BEAM_LENGTH, (Object)Float.valueOf(0.0f));
        builder.define(BEAM_OFFSET, (Object)Float.valueOf(0.0f));
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A, (Object)Float.valueOf(0.0f));
        builder.define(SHOOTING_TICKS, (Object)-1);
        builder.define(DISTANCE, (Object)Float.valueOf(0.0f));
    }

    public void tick() {
        super.tick();
        this.setDeltaMovement(0.0, 0.0, 0.0);
        if (this.getLife() < 20) {
            this.setLife(this.getLife() + 1);
        }
        this.yRotO = this.yRot;
        if (this.yRotO < 0.0f) {
            this.yRotO += 360.0f;
        }
        this.setRotationYaw(this.getRotationYaw() + this.getRotationSpeed());
        this.yRot = this.getRotationYaw();
        this.xRot = this.getRotationPitch();
        this.setRot(this.yRot, this.xRot);
        if (!this.level().isClientSide) {
            if (this.casterUUID == null) {
                this.discard();
            } else {
                Player caster = this.level().getPlayerByUUID(this.casterUUID);
                if (caster == null || !caster.isAlive()) {
                    this.discard();
                } else {
                    if (!(caster.getUseItem().getItem() instanceof MysticStaff && this.getShootingTicks() < 0 || this.target != null)) {
                        this.discard();
                    }
                    if (this.target != null) {
                        int shooting = this.getShootingTicks();
                        int shootFinish = 12;
                        int maxBeamLength = 6;
                        if (shooting >= 0 && shooting < shootFinish + maxBeamLength) {
                            this.setBeamOffset(this.getBeamOffset() - this.getDistance() / (float)shootFinish);
                            this.setBeamSize(this.getBeamSize() + 0.03f);
                            if (shooting < maxBeamLength) {
                                this.setBeamLength(this.getBeamLength() + this.getDistance() / (float)shootFinish);
                            }
                            if (shooting > shootFinish) {
                                this.setBeamLength(this.getBeamLength() - this.getDistance() / (float)shootFinish);
                            }
                            this.setShootingTicks(this.getShootingTicks() + 1);
                        } else if (shooting >= shootFinish + maxBeamLength) {
                            double x = this.target.x;
                            double y = this.target.y;
                            double z = this.target.z;
                            int radius = MTConfig.MYSTIC_STAFF_AOE_SIZE;
                            Bakuretsu explosion = new Bakuretsu(radius, (float)x, (float)y, (float)z, MysticStaff.getExplosionDamage(true, Utils.getPlayerMahou(caster)));
                            explosion.explosionA(this.level(), caster);
                            for (Player entityplayer : this.level().players()) {
                                if (!(entityplayer.distanceToSqr(x, y, z) < 16384.0)) continue;
                                Vec3 vec = null;
                                if (explosion.knockback.containsKey(caster)) {
                                    vec = explosion.knockback.get(caster);
                                }
                                if (vec == null) {
                                    PacketHandler.sendTo((ServerPlayer)caster, new BakuretsuPacket(x, y, z, radius, 0.0f, 0.0f, 0.0f));
                                    continue;
                                }
                                PacketHandler.sendTo((ServerPlayer)caster, new BakuretsuPacket(x, y, z, radius, (float)vec.x, (float)vec.y, (float)vec.z));
                            }
                            this.discard();
                        }
                    }
                }
            }
        }
    }

    public void startShoot(Vec3 target) {
        this.setShootingTicks(0);
        this.target = target;
    }

    public AABB getBoundingBox() {
        return ZERO_AABB;
    }

    public void setColor(float r, float g, float b, float a) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        this.entityData.set(COLOR_A, (Object)Float.valueOf(a));
    }

    public float[] getColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue(), ((Float)this.entityData.get(COLOR_A)).floatValue()};
    }

    public void angleCircleAroundBlock(float circleDegrees, float groundDegrees, float distance, Vec3 pos) {
        double height = (double)distance * Math.cos(MysticStaffMahoujinEntity.toRad(groundDegrees));
        double radius = Math.sqrt((double)(distance * distance) - height * height);
        double zplus = radius * Math.sin(MysticStaffMahoujinEntity.toRad(circleDegrees));
        double xplus = -radius * Math.cos(MysticStaffMahoujinEntity.toRad(circleDegrees));
        this.setRotationPitch(groundDegrees);
        this.setRotationRoll(circleDegrees - 90.0f);
        this.setPos(pos.x + xplus, pos.y + height, pos.z + zplus);
    }

    public static float toRad(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public void setCasterUUID(UUID uuid) {
        this.casterUUID = uuid;
    }

    public void sizer(float f) {
        this.setCircleSize(f);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.setRotationYaw(compound.getFloat(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.getFloat(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.getFloat(TAG_ROTATION_PITCH));
        this.setRotationSpeed(compound.getFloat("MAHOUTSUKAI_ROTATION_SPEED"));
        this.setCircleSize(compound.getFloat("MAHOUTSUKAI_ROTATION_SPEED"));
        this.setLife(compound.getInt(TAG_LIFE));
        this.setHasBeam(compound.getBoolean(TAG_BEAM));
        this.setBeamSize(compound.getFloat(TAG_BEAM_SIZE));
        this.setBeamLength(compound.getFloat(TAG_BEAM_LENGTH));
        this.setBeamOffset(compound.getFloat(TAG_BEAM_OFFSET));
        this.casterUUID = compound.getUUID(TAG_CASTER);
        this.setColor(compound.getFloat(TAG_COLOR_R), compound.getFloat(TAG_COLOR_G), compound.getFloat(TAG_COLOR_B), compound.getFloat(TAG_COLOR_A));
        this.setShootingTicks(compound.getInt(TAG_SHOOTING_TICKS));
        this.setDistance(compound.getFloat(TAG_DISTANCE));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.putFloat(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.putFloat(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.putFloat("MAHOUTSUKAI_ROTATION_SPEED", this.getRotationSpeed());
        compound.putFloat("MAHOUTSUKAI_ROTATION_SPEED", this.getCircleSize());
        compound.putInt(TAG_LIFE, this.getLife());
        compound.putUUID(TAG_CASTER, this.casterUUID);
        compound.putFloat(TAG_BEAM_OFFSET, this.getBeamOffset());
        compound.putFloat(TAG_BEAM_LENGTH, this.getBeamLength());
        compound.putBoolean(TAG_BEAM, this.hasBeam());
        compound.putFloat(TAG_BEAM_SIZE, this.getBeamSize());
        float[] colors = this.getColor();
        compound.putFloat(TAG_COLOR_R, colors[0]);
        compound.putFloat(TAG_COLOR_G, colors[1]);
        compound.putFloat(TAG_COLOR_B, colors[2]);
        compound.putFloat(TAG_COLOR_A, colors[3]);
        compound.putInt(TAG_SHOOTING_TICKS, this.getShootingTicks());
        compound.putFloat(TAG_DISTANCE, this.getDistance());
    }

    public AABB getBoundingBoxForCulling() {
        return bb;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    public float getRotationYaw() {
        return ((Float)this.entityData.get(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.entityData.set(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.entityData.get(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.entityData.set(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.entityData.get(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.entityData.set(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public float getRotationSpeed() {
        return ((Float)this.entityData.get(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float s) {
        this.entityData.set(ROTATION_SPEED, (Object)Float.valueOf(s));
    }

    public float getCircleSize() {
        return ((Float)this.entityData.get(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.entityData.set(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.entityData.get(LIFE);
    }

    public void setLife(int l) {
        this.entityData.set(LIFE, (Object)l);
    }

    public boolean hasBeam() {
        return (Boolean)this.entityData.get(BEAM);
    }

    public void setHasBeam(boolean b) {
        this.entityData.set(BEAM, (Object)b);
    }

    public float getBeamSize() {
        return ((Float)this.entityData.get(BEAM_SIZE)).floatValue();
    }

    public void setBeamSize(float b) {
        this.entityData.set(BEAM_SIZE, (Object)Float.valueOf(b));
    }

    public float getBeamLength() {
        return ((Float)this.entityData.get(BEAM_LENGTH)).floatValue();
    }

    public void setBeamLength(float b) {
        this.entityData.set(BEAM_LENGTH, (Object)Float.valueOf(b));
    }

    public float getBeamOffset() {
        return ((Float)this.entityData.get(BEAM_OFFSET)).floatValue();
    }

    public void setBeamOffset(float b) {
        this.entityData.set(BEAM_OFFSET, (Object)Float.valueOf(b));
    }

    public int getShootingTicks() {
        return (Integer)this.entityData.get(SHOOTING_TICKS);
    }

    public void setShootingTicks(int t) {
        this.entityData.set(SHOOTING_TICKS, (Object)t);
    }

    public float getDistance() {
        return ((Float)this.entityData.get(DISTANCE)).floatValue();
    }

    public void setDistance(float d) {
        this.entityData.set(DISTANCE, (Object)Float.valueOf(d));
    }
}

