/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.projection;

import io.netty.util.internal.ConcurrentSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.advancements.MahouTrigger;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.config.MandatoryFun;
import stepsword.mahoutsukai.dataattachments.chunks.IChunkMahou;
import stepsword.mahoutsukai.datacomponents.sword.SwordMahou;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.fluids.MurkyWaterBlock;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.caliburn.Caliburn;
import stepsword.mahoutsukai.item.morgan.Morgan;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.networking.ChunkMahouRequestPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.SweepAttackPacket;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.PlayerHelp;
import stepsword.mahoutsukai.util.Utils;

public class PowerConsolidationSpellEffect {
    public static void powerConsolidationWorldTick(final LevelTickEvent.Post event) {
        block28: {
            if (!event.getLevel().isClientSide && ServerHandler.tickCounter % (long)MTConfig.POWER_CONSOLIDATION_LAKE_CYCLE == 0L) {
                Entity failed = null;
                try {
                    final int manaCost = MTConfig.POWER_CONSOLIDATION_SWORD_MANA_COST;
                    double nerfFactor = MTConfig.POWER_CONSOLIDATION_NERF_FACTOR;
                    Iterator iter = ((ServerLevel)event.getLevel()).getEntities().getAll().iterator();
                    final ArrayList<ItemEntity> toDelete = new ArrayList<ItemEntity>();
                    final ArrayList<WeaponProjectileEntity> toSpawn = new ArrayList<WeaponProjectileEntity>();
                    while (iter.hasNext()) {
                        Entity e = (Entity)iter.next();
                        if (!(e instanceof ItemEntity)) continue;
                        ItemEntity item = (ItemEntity)e;
                        failed = e;
                        if (item.getItem().getItem() instanceof SwordItem) {
                            boolean inMurkyWater = Utils.isInMurkyWater(e);
                            boolean isAllowed = PowerConsolidationSpellEffect.isItemAllowed(item.getItem(), e.level());
                            boolean isEnchanted = item.getItem().isEnchanted();
                            boolean hasOwner = item.getOwner() instanceof Player;
                            if (!hasOwner && inMurkyWater) {
                                PlayerHelp.sendHelpMessageNearby(e.blockPosition(), e.level(), PlayerHelp.Message.CALIBURN_NO_OWNER);
                            }
                            if (hasOwner && inMurkyWater) {
                                Player player = (Player)item.getOwner();
                                if (isAllowed) {
                                    if (isEnchanted) {
                                        ConcurrentSet connected = new ConcurrentSet();
                                        boolean lt = PowerConsolidationSpellEffect.lakeThreshhold(item.blockPosition(), (ConcurrentSet<BlockPos>)connected, event.getLevel());
                                        if (lt) {
                                            if (MandatoryFun.meetsAllFunReqs(player)) {
                                                if (PlayerManaManager.hasMana(player, manaCost)) {
                                                    BlockPos p = PowerConsolidationSpellEffect.findCenter((ConcurrentSet<BlockPos>)connected);
                                                    if (!Utils.isBlockAir(event.getLevel(), p)) {
                                                        p = p.below();
                                                    }
                                                    ItemStack stack = new ItemStack((ItemLike)ModItems.caliburn.get());
                                                    SwordMahou mahou = Utils.getSwordMahou(stack);
                                                    double lb = PowerConsolidationSpellEffect.getLimitBreakInArea(item);
                                                    if (item.getItem().getItem() instanceof Caliburn) {
                                                        SwordMahou orig = Utils.getSwordMahou(item.getItem());
                                                        if (orig != null) {
                                                            lb = Math.max(orig.getInnateCap(), lb);
                                                        }
                                                        if (item.getItem().has(DataComponents.CUSTOM_NAME)) {
                                                            Component name = item.getItem().getHoverName();
                                                            stack.set(DataComponents.CUSTOM_NAME, (Object)name);
                                                        }
                                                    }
                                                    mahou.setInnateCap(lb);
                                                    float damage = Caliburn.simulateHit(item.getItem(), event.getLevel());
                                                    ItemStack stackCopy = item.getItem().copy();
                                                    EnchantmentHelper.updateEnchantments((ItemStack)stackCopy, mutableEnchants -> mutableEnchants.removeIf(a -> true));
                                                    if (MTConfig.POWER_CONSOLIDATION_UNSOCKETS_APOTH_GEMS) {
                                                        stackCopy = MahouTsukaiMod.apotheosis.unsocket(stackCopy);
                                                    }
                                                    float damageWithoutEnchant = Caliburn.simulateHit(stackCopy, event.getLevel());
                                                    damage = (float)((double)damage - nerfFactor * (double)(damage - damageWithoutEnchant));
                                                    mahou.setAttackDamage(Math.min((float)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP, damage -= 1.0f));
                                                    Utils.setSwordMahou(stack, mahou);
                                                    Utils.debug("Advancement Time");
                                                    ((MahouTrigger)((Object)ModTriggers.SWORD_IN_THE_LAKE.get())).trigger((ServerPlayer)player);
                                                    WeaponProjectileEntity wpe = new WeaponProjectileEntity(event.getLevel(), p.getX(), p.getY(), p.getZ(), stack);
                                                    wpe.setDeltaMovement(0.0, -1.0, 0.0);
                                                    wpe.setOwner((Entity)player);
                                                    toSpawn.add(wpe);
                                                    toDelete.add(item);
                                                } else {
                                                    PlayerHelp.sendHelpMessage(player, PlayerHelp.Message.NOT_ENOUGH_MANA);
                                                }
                                            } else {
                                                IItemHandler inventory = Utils.getInventory((LivingEntity)player);
                                                int sizeInventory = inventory.getSlots();
                                                ItemStack stack = new ItemStack((ItemLike)ModItems.funbook.get());
                                                boolean hasBook = false;
                                                boolean hasSpace = false;
                                                for (int i = 0; i < sizeInventory; ++i) {
                                                    ItemStack slot = inventory.getStackInSlot(i);
                                                    if (ItemStack.isSameItem((ItemStack)slot, (ItemStack)stack)) {
                                                        hasBook = true;
                                                    }
                                                    if (!slot.isEmpty()) continue;
                                                    hasSpace = true;
                                                }
                                                if (!hasBook && hasSpace) {
                                                    player.addItem(stack);
                                                } else if (!hasSpace && !hasBook) {
                                                    PlayerHelp.sendHelpMessage(player, PlayerHelp.Message.NO_FUN_NO_SPACE);
                                                }
                                                PlayerHelp.sendHelpMessage(player, PlayerHelp.Message.NOT_ENOUGH_FUN);
                                            }
                                        } else {
                                            PlayerHelp.sendHelpMessage(player, PlayerHelp.Message.CALIBURN_LAKE_TOO_SMALL);
                                        }
                                    } else {
                                        PlayerHelp.sendHelpMessage(player, PlayerHelp.Message.CALIBURN_NOT_ENCHANTED);
                                    }
                                } else {
                                    PlayerHelp.sendHelpMessage(player, PlayerHelp.Message.CALIBURN_SWORD_BANNED);
                                }
                            }
                        }
                        MahouTsukaiMod.jousting.powerConsolidation((LevelTickEvent)event, item, toDelete, toSpawn, manaCost);
                    }
                    if (toDelete.size() > 0) {
                        ((ServerLevel)event.getLevel()).getServer().execute(new Runnable(){

                            @Override
                            public void run() {
                                for (int i = 0; i < toDelete.size(); ++i) {
                                    ItemEntity e = (ItemEntity)toDelete.get(i);
                                    Utils.debug("Item alive:" + e.isAlive() + "... Thrower:" + String.valueOf(e.getOwner()));
                                    if (!e.isAlive() || !(e.getOwner() instanceof Player) || i >= toSpawn.size() || PlayerManaManager.drainMana((Player)e.getOwner(), manaCost, false, false) != manaCost) continue;
                                    Utils.debug("Mana charged and item spawning.");
                                    event.getLevel().addFreshEntity((Entity)toSpawn.get(i));
                                    e.discard();
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Utils.err(e.toString());
                    if (failed == null) break block28;
                    PlayerHelp.sendHelpMessageNearby(failed.blockPosition(), failed.level(), PlayerHelp.Message.CALIBURN_INTERNAL_ERROR);
                }
            }
        }
    }

    public static double getLimitBreakInArea(ItemEntity entity) {
        Vec3 vec = entity.position();
        int radius = 10;
        AABB aabb = new AABB(vec.x - (double)radius, vec.y - (double)radius, vec.z - (double)radius, vec.x + (double)radius, vec.y + (double)radius, vec.z + (double)radius);
        int limit_breaks = 0;
        List entities = entity.level().getEntitiesOfClass(ItemEntity.class, aabb);
        for (ItemEntity e : entities) {
            if (!EffectUtil.inItemBlacklist(e.getItem().getItem(), MTConfig.POWER_CONSOLIDATION_TIER_UPGRADE_ITEM, e.level())) continue;
            limit_breaks += e.getItem().getCount();
            e.discard();
        }
        double ret = MTConfig.POWER_CONSOLIDATION_ATTACK_CAP;
        if (MTConfig.POWER_CONSOLIDATION_TIERS.size() > 0) {
            ret = MTConfig.POWER_CONSOLIDATION_TIERS.get(0);
            if (limit_breaks > 0) {
                ret = MTConfig.POWER_CONSOLIDATION_TIERS.get(Math.min(MTConfig.POWER_CONSOLIDATION_TIERS.size() - 1, limit_breaks));
            }
        }
        return ret;
    }

    public static boolean isItemAllowed(ItemStack s, Level level) {
        boolean blacklist = MTConfig.POWER_CONSOLIDATION_CALIBURN_BLACKLIST_TOGGLE;
        ArrayList list = (ArrayList)MTConfig.POWER_CONSOLIDATION_BLACKLIST;
        boolean match = false;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null || s == null || Utils.getRegistryKey(s.getItem(), level) == null || !((String)list.get(i)).equals(Utils.getRegistryName(s.getItem(), level))) continue;
            match = true;
            break;
        }
        if (s != null && !MTConfig.POWER_CONSOLIDATION_PROJECTIONS_ALLOWED && ProjectionSpellEffect.getProjected(s) && s.getItem() instanceof Caliburn) {
            return false;
        }
        if (match && blacklist) {
            return false;
        }
        if (match && !blacklist) {
            return true;
        }
        return !match && blacklist;
    }

    public static BlockPos findCenter(ConcurrentSet<BlockPos> connected) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (BlockPos p : connected) {
            if (p.getX() < minX) {
                minX = p.getX();
            }
            if (p.getX() > maxX) {
                maxX = p.getX();
            }
            if (p.getZ() < minZ) {
                minZ = p.getZ();
            }
            if (p.getZ() > maxZ) {
                maxZ = p.getZ();
            }
            if (p.getY() <= maxY) continue;
            maxY = p.getY();
        }
        return new BlockPos(PowerConsolidationSpellEffect.average(maxX, minX), maxY + 1, PowerConsolidationSpellEffect.average(maxZ, minZ));
    }

    public static int average(int a, int b) {
        return (a + b) / 2;
    }

    public static boolean lakeThreshhold(BlockPos p, ConcurrentSet<BlockPos> connected, Level world) {
        int threshhold = MTConfig.POWER_CONSOLIDATION_LAKE_THRESHHOLD;
        if (connected.size() > threshhold) {
            return true;
        }
        if (connected.contains((Object)p)) {
            return false;
        }
        boolean ret = false;
        if (world != null) {
            if (world.getBlockState(p).getBlock() instanceof MurkyWaterBlock) {
                connected.add((Object)p);
            }
            if (world.getBlockState(p.above()).getBlock() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.above(), connected, world))) {
                return true;
            }
            if (world.getBlockState(p.below()).getBlock() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.below(), connected, world))) {
                return true;
            }
            if (world.getBlockState(p.south()).getBlock() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.south(), connected, world))) {
                return true;
            }
            if (world.getBlockState(p.west()).getBlock() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.west(), connected, world))) {
                return true;
            }
            if (world.getBlockState(p.east()).getBlock() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.east(), connected, world))) {
                return true;
            }
            if (world.getBlockState(p.north()).getBlock() instanceof MurkyWaterBlock && (ret = PowerConsolidationSpellEffect.lakeThreshhold(p.north(), connected, world))) {
                return true;
            }
        }
        return ret;
    }

    public static void caliburnLeftClickSpace(PlayerInteractEvent.LeftClickEmpty event) {
        PowerConsolidationSpellEffect.sweepAttack((PlayerInteractEvent)event);
    }

    public static void caliburnLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        PowerConsolidationSpellEffect.sweepAttack((PlayerInteractEvent)event);
    }

    public static void sweepAttack(PlayerInteractEvent event) {
        Player player = event.getEntity();
        if (player.level().isClientSide && (player.getMainHandItem().getItem() instanceof Caliburn || player.getMainHandItem().getItem() instanceof Morgan)) {
            int r = MTConfig.POWER_CONSOLIDATION_SWEEP_RADIUS;
            int r2 = MTConfig.POWER_CONSOLIDATION_SWEEP_LOOK_RADIUS;
            Vec3 p = player.position();
            AABB aabb = new AABB(p.add((double)(-r), (double)(-r), (double)(-r)), p.add((double)r, (double)r, (double)r));
            List lst = player.level().getEntitiesOfClass(LivingEntity.class, aabb);
            for (LivingEntity e : lst) {
                if (e.getUUID().equals(player.getUUID()) || !EffectUtil.isLookingAtMe(e, (LivingEntity)player) || !(Math.abs(EffectUtil.pointToLineDistance(e.position(), player.getEyePosition(1.0f), player.getLookAngle().add(player.getEyePosition(1.0f)))) < (double)r2)) continue;
                PacketHandler.sendToServer(new SweepAttackPacket((Entity)e));
            }
        }
    }

    public static void powerConsolidationChunkLoad(ChunkEvent.Load event) {
        if (event.getChunk() instanceof LevelChunk) {
            IChunkMahou mahou;
            LevelChunk c = (LevelChunk)event.getChunk();
            if (event.getLevel().isClientSide()) {
                PacketHandler.sendToServer(new ChunkMahouRequestPacket(c.getPos().x, c.getPos().z));
            } else if (MTConfig.POWER_CONSOLIDATION_RETRO_FOG_FIX && (mahou = Utils.getChunkMahou(c)) != null && mahou.needsRetroFixLake()) {
                ConcurrentSet<BlockPos> lakeBlocks = mahou.getLakeBlocks();
                for (int i = c.getPos().getMinBlockX(); i <= c.getPos().getMaxBlockX(); ++i) {
                    for (int j = c.getPos().getMinBlockZ(); j <= c.getPos().getMaxBlockZ(); ++j) {
                        for (int y = c.getLevel().getMinBuildHeight(); y < c.getLevel().getMaxBuildHeight(); ++y) {
                            BlockPos p = new BlockPos(i, y, j);
                            if (c.getBlockState(p).getBlock() != ModBlocks.murkyFluid.get()) continue;
                            lakeBlocks.add((Object)p);
                        }
                    }
                }
                mahou.setNeedsRetroFixLake(false);
            }
        }
    }
}

