/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.dataattachments.chunks;

import io.netty.util.internal.ConcurrentSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import stepsword.mahoutsukai.dataattachments.chunks.IChunkMahou;
import stepsword.mahoutsukai.util.Utils;

public class ChunkMahouStorage {
    public static String LAKE_LIST = "MAHOU_LAKE_LIST";
    public static String LAKE_BLOCK = "m";
    public static String LAKE_RETRO = "MAHOU_LAKE_RETRO";
    public static String FOG_LIST = "MAHOU_FOG_LIST";
    public static String FOG_BLOCK = "f";

    public static Tag writeNBT(IChunkMahou instance) {
        CompoundTag nbt = new CompoundTag();
        ListTag lakeList = new ListTag();
        if (instance.getLakeBlocks() != null) {
            for (BlockPos p : instance.getLakeBlocks()) {
                if (p == null) continue;
                lakeList.add(0, (Tag)Utils.blockposToNBT(p, LAKE_BLOCK));
            }
        }
        nbt.put(LAKE_LIST, (Tag)lakeList);
        ListTag fogList = new ListTag();
        if (instance.getFogProjectors() != null) {
            for (BlockPos p : instance.getFogProjectors()) {
                if (p == null) continue;
                fogList.add(0, (Tag)Utils.blockposToNBT(p, FOG_BLOCK));
            }
        }
        nbt.put(FOG_LIST, (Tag)fogList);
        nbt.putBoolean(LAKE_RETRO, instance.needsRetroFixLake());
        return nbt;
    }

    public static void readNBT(IChunkMahou instance, Tag nbtb) {
        BlockPos p;
        CompoundTag blockNBT;
        int i;
        CompoundTag nbt = (CompoundTag)nbtb;
        if (nbt.contains(LAKE_LIST)) {
            ConcurrentSet lakeBlocks = new ConcurrentSet();
            ListTag lakeList = (ListTag)nbt.get(LAKE_LIST);
            if (lakeList != null) {
                for (i = 0; i < lakeList.size(); ++i) {
                    blockNBT = (CompoundTag)lakeList.get(i);
                    p = Utils.NBTtoBlockPos(blockNBT, LAKE_BLOCK);
                    lakeBlocks.add((Object)p);
                }
            }
            instance.setLakeBlocks((ConcurrentSet<BlockPos>)lakeBlocks);
        }
        if (nbt.contains(FOG_LIST)) {
            ConcurrentSet fogBlocks = new ConcurrentSet();
            ListTag fogList = (ListTag)nbt.get(FOG_LIST);
            if (fogList != null) {
                for (i = 0; i < fogList.size(); ++i) {
                    blockNBT = (CompoundTag)fogList.get(i);
                    p = Utils.NBTtoBlockPos(blockNBT, FOG_BLOCK);
                    if (p == null) continue;
                    fogBlocks.add((Object)p);
                }
            }
            instance.setFogProjectors((ConcurrentSet<BlockPos>)fogBlocks);
        }
        instance.setNeedsRetroFixLake(nbt.getBoolean(LAKE_RETRO));
    }
}

