/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;

public class CustomTrigger
implements CriterionTrigger<Instance> {
    private final ResourceLocation RL;
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();
    Codec<Instance> CODEC = RecordCodecBuilder.create(p_337390_ -> p_337390_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("mahou").forGetter(Instance::serialize), (App)ResourceLocation.CODEC.fieldOf("loc").forGetter(Instance::getCriterion)).apply((Applicative)p_337390_, Instance::new));

    public CustomTrigger(String parString) {
        this.RL = ResourceLocation.parse((String)parString);
    }

    public CustomTrigger(ResourceLocation parRL) {
        this.RL = parRL;
    }

    public ResourceLocation getId() {
        return this.RL;
    }

    public void addPlayerListener(PlayerAdvancements playerAdvancements, CriterionTrigger.Listener listener) {
        Listeners myCustomTrigger$listeners = this.listeners.get(playerAdvancements);
        if (myCustomTrigger$listeners == null) {
            myCustomTrigger$listeners = new Listeners(playerAdvancements);
            this.listeners.put(playerAdvancements, myCustomTrigger$listeners);
        }
        myCustomTrigger$listeners.add((CriterionTrigger.Listener<Instance>)listener);
    }

    public void removePlayerListener(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener listener) {
        Listeners tameanimaltrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (tameanimaltrigger$listeners != null) {
            tameanimaltrigger$listeners.remove((CriterionTrigger.Listener<Instance>)listener);
            if (tameanimaltrigger$listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void removePlayerListeners(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Codec codec() {
        return this.CODEC;
    }

    public void trigger(ServerPlayer parPlayer) {
        Listeners tameanimaltrigger$listeners = this.listeners.get(parPlayer.getAdvancements());
        if (tameanimaltrigger$listeners != null) {
            tameanimaltrigger$listeners.trigger(parPlayer);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<CriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(ServerPlayer player) {
            ArrayList list = null;
            for (CriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.trigger()).test()) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (CriterionTrigger.Listener listener1 : list) {
                    listener1.run(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    implements CriterionTriggerInstance {
        ResourceLocation rl;

        public Instance(Optional<ContextAwarePredicate> context, ResourceLocation parRL) {
            this.rl = parRL;
        }

        public boolean test() {
            return true;
        }

        public ResourceLocation getCriterion() {
            return this.rl;
        }

        public Optional<ContextAwarePredicate> serialize() {
            return Optional.empty();
        }

        public void validate(CriterionValidator pValidator) {
        }
    }
}

