/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity.ai;

import com.tristankechlo.livingthings.block.OstrichNestBlock;
import com.tristankechlo.livingthings.init.ModBlocks;
import com.tristankechlo.livingthings.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.Vec3;

public class BreakOstrichEggGoal
extends MoveToBlockGoal {
    private final Block block = ModBlocks.OSTRICH_NEST.get();
    private final Mob entity;
    private int breakingTime;
    private boolean destroyNestComplete;
    private int chance;

    public BreakOstrichEggGoal(PathfinderMob creatureIn, double speed, int yMax, int chance, boolean destroyNestComplete) {
        super(creatureIn, speed, 12, yMax);
        this.entity = creatureIn;
        this.destroyNestComplete = destroyNestComplete;
        this.chance = chance;
    }

    public boolean canUse() {
        if (!this.entity.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return false;
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        if (this.shouldMoveToDestination()) {
            this.nextStartTick = 20;
            return this.entity.getRandom().nextInt(this.chance) == 0;
        }
        this.nextStartTick = this.nextStartTick(this.mob);
        return false;
    }

    private boolean shouldMoveToDestination() {
        return this.blockPos != null && this.isValidTarget((LevelReader)this.mob.level(), this.blockPos) ? true : this.findNearestBlock();
    }

    public void stop() {
        super.stop();
        this.entity.fallDistance = 1.0f;
    }

    public void start() {
        super.start();
        this.breakingTime = 0;
    }

    public void playBreakingSound(LevelAccessor worldIn, BlockPos pos) {
        worldIn.playSound(null, pos, ModSounds.OSTRICH_EGG_CRACKS.get(), SoundSource.HOSTILE, 0.5f, 0.9f + this.entity.getRandom().nextFloat() * 0.2f);
    }

    public void playBrokenSound(Level worldIn, BlockPos pos) {
        worldIn.playSound(null, pos, ModSounds.OSTRICH_EGG_CRACKS.get(), SoundSource.BLOCKS, 0.7f, 0.9f + worldIn.random.nextFloat() * 0.2f);
    }

    public void tick() {
        super.tick();
        Level world = this.entity.level();
        BlockPos blockpos = this.entity.blockPosition();
        BlockPos blockpos1 = this.findTarget(blockpos, (BlockGetter)world);
        RandomSource random = this.entity.getRandom();
        if (this.isReachedTarget() && blockpos1 != null) {
            if (this.breakingTime > 0) {
                Vec3 vector3d = this.entity.getDeltaMovement();
                this.entity.setDeltaMovement(vector3d.x, 0.3, vector3d.z);
                if (!world.isClientSide()) {
                    ((ServerLevel)world).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.EGG)), (double)blockpos1.getX() + 0.5, (double)blockpos1.getY() + 0.7, (double)blockpos1.getZ() + 0.5, 3, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, (double)0.15f);
                }
            }
            if (this.breakingTime % 2 == 0) {
                Vec3 vector3d1 = this.entity.getDeltaMovement();
                this.entity.setDeltaMovement(vector3d1.x, -0.3, vector3d1.z);
                if (this.breakingTime % 6 == 0) {
                    this.playBreakingSound((LevelAccessor)world, this.blockPos);
                }
            }
            if (this.breakingTime > 60) {
                if (this.destroyNestComplete) {
                    world.removeBlock(blockpos1, false);
                } else {
                    world.setBlockAndUpdate(blockpos1, (BlockState)world.getBlockState(blockpos1).setValue((Property)OstrichNestBlock.EGG, (Comparable)Boolean.valueOf(false)));
                }
                if (!world.isClientSide()) {
                    for (int i = 0; i < 20; ++i) {
                        double d3 = random.nextGaussian() * 0.02;
                        double d1 = random.nextGaussian() * 0.02;
                        double d2 = random.nextGaussian() * 0.02;
                        ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.POOF, (double)blockpos1.getX() + 0.5, (double)blockpos1.getY(), (double)blockpos1.getZ() + 0.5, 1, d3, d1, d2, (double)0.15f);
                    }
                    this.playBrokenSound(world, blockpos1);
                }
            }
            ++this.breakingTime;
        }
    }

    private BlockPos findTarget(BlockPos pos, BlockGetter worldIn) {
        BlockPos[] ablockpos;
        if (worldIn.getBlockState(pos).is(this.block)) {
            if (((Boolean)worldIn.getBlockState(pos).getValue((Property)OstrichNestBlock.EGG)).booleanValue()) {
                return pos;
            }
            return null;
        }
        for (BlockPos blockpos : ablockpos = new BlockPos[]{pos.below(), pos.west(), pos.east(), pos.north(), pos.south(), pos.below().below()}) {
            if (!worldIn.getBlockState(blockpos).is(this.block) || !((Boolean)worldIn.getBlockState(blockpos).getValue((Property)OstrichNestBlock.EGG)).booleanValue()) continue;
            return blockpos;
        }
        return null;
    }

    protected boolean isValidTarget(LevelReader worldIn, BlockPos pos) {
        ChunkAccess ichunk = worldIn.getChunk(pos.getX() >> 4, pos.getZ() >> 4, ChunkStatus.FULL, false);
        if (ichunk == null) {
            return false;
        }
        if (ichunk.getBlockState(pos).is(this.block)) {
            return (Boolean)ichunk.getBlockState(pos).getValue((Property)OstrichNestBlock.EGG) != false && ichunk.getBlockState(pos.above()).isAir() && ichunk.getBlockState(pos.above(2)).isAir();
        }
        return false;
    }

    public double acceptedDistance() {
        return 1.25;
    }
}

