/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.entity.ElephantEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ElephantModel<T extends ElephantEntity>
extends AdvancedEntityModel<T> {
    private final ModelPart Tusks;
    private final ModelPart Body;
    private final ModelPart Chests;
    private final ModelPart Saddle;
    private final ModelPart Head;
    private final ModelPart TrunkTop;
    private final ModelPart TrunkMiddle;
    private final ModelPart TrunkBottom;
    private final ModelPart RightFrontLeg;
    private final ModelPart LeftFrontLeg;
    private final ModelPart RightBackLeg;
    private final ModelPart LeftBackLeg;
    private final ModelPart LeftEar;
    private final ModelPart RightEar;
    private float headAngle;

    public ElephantModel(ModelPart root) {
        this.Body = root.getChild("Body");
        this.Chests = this.Body.getChild("Chests");
        this.Saddle = this.Body.getChild("Saddle");
        this.Head = this.Body.getChild("Head");
        this.LeftEar = this.Head.getChild("LeftEar");
        this.RightEar = this.Head.getChild("RightEar");
        this.Tusks = this.Head.getChild("Tusks");
        this.TrunkTop = this.Head.getChild("TrunkTop");
        this.TrunkMiddle = this.TrunkTop.getChild("TrunkMiddle");
        this.TrunkBottom = this.TrunkMiddle.getChild("TrunkBottom");
        this.RightFrontLeg = this.Body.getChild("RightFrontLeg");
        this.LeftFrontLeg = this.Body.getChild("LeftFrontLeg");
        this.RightBackLeg = this.Body.getChild("RightBackLeg");
        this.LeftBackLeg = this.Body.getChild("LeftBackLeg");
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        if (this.young) {
            poseStack.scale(0.6f, 0.6f, 0.6f);
            poseStack.translate(0.0f, 1.0f, 0.0f);
        }
        this.Body.render(poseStack, buffer, packedLight, packedOverlay);
    }

    public void setupAnim(ElephantEntity elephant, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.xRot = elephant.getAttackTimer() > 0 ? this.headAngle : -0.0436332f + headPitch * ((float)Math.PI / 180);
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.walk(this.RightFrontLeg, this.LeftFrontLeg, this.RightBackLeg, this.LeftBackLeg, limbSwing, limbSwingAmount);
        if (elephant.isAngry()) {
            this.LeftEar.yRot = 1.13446f;
            this.LeftEar.zRot = 0.1309f;
            this.RightEar.yRot = -1.13446f;
            this.RightEar.zRot = -0.1309f;
        } else {
            this.LeftEar.yRot = 0.4799655f + 0.3f * Mth.sin((float)(0.1f * ageInTicks + 1.0f + (float)Math.PI));
            this.LeftEar.zRot = 0.0f;
            this.RightEar.yRot = -0.4799655f + 0.3f * Mth.sin((float)(0.1f * ageInTicks + 1.0f));
            this.RightEar.zRot = 0.0f;
        }
        this.TrunkTop.xRot = 0.0436332f + 0.1f * Mth.sin((float)(0.1f * ageInTicks + 1.0f));
        this.TrunkTop.zRot = 0.1f * Mth.sin((float)(0.1f * ageInTicks + 1.0f));
        this.TrunkMiddle.xRot = 0.0436332f + 0.15f * Mth.cos((float)(0.1f * ageInTicks + 2.0f));
        this.TrunkMiddle.zRot = 0.15f * Mth.cos((float)(0.1f * ageInTicks + 2.0f));
        this.TrunkBottom.xRot = 0.0872665f + 0.2f * Mth.sin((float)(0.1f * ageInTicks + 2.0f));
        this.TrunkBottom.zRot = 0.2f * Mth.sin((float)(0.1f * ageInTicks + 2.0f));
    }

    public void prepareMobModel(ElephantEntity elephant, float limbSwing, float limbSwingAmount, float partialTick) {
        float i = elephant.getAttackTimer();
        if (i > 0.0f) {
            float progress = 1.0f - (i - partialTick) / 10.0f;
            this.headAngle = Mth.lerp((float)progress, (float)0.174533f, (float)-0.959931f);
        }
        this.Chests.visible = elephant.hasChest();
        this.Saddle.visible = elephant.isSaddled();
        this.Tusks.visible = !this.young;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 65).addBox(-11.0f, -41.0f, -20.0f, 22.0f, 23.0f, 40.0f, new CubeDeformation(0.0f)).texOffs(156, 93).addBox(-8.0f, -42.0f, -17.0f, 16.0f, 1.0f, 34.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)25.0f, (float)0.0f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(123, 45).addBox(-9.0f, -9.0f, -12.0f, 18.0f, 16.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-35.0f, (float)-20.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition TrunkTop = Head.addOrReplaceChild("TrunkTop", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -0.1f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)-8.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition TrunkMiddle = TrunkTop.addOrReplaceChild("TrunkMiddle", CubeListBuilder.create().texOffs(0, 26).addBox(-3.0f, -0.2f, -3.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition TrunkBottom = TrunkMiddle.addOrReplaceChild("TrunkBottom", CubeListBuilder.create().texOffs(0, 44).addBox(-2.0f, 0.7f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition LeftEar = Head.addOrReplaceChild("LeftEar", CubeListBuilder.create().texOffs(220, 37).mirror().addBox(0.0f, -8.0f, 0.0f, 1.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)9.0f, (float)-1.0f, (float)-6.0f, (float)0.1309f, (float)0.48f, (float)0.0f));
        PartDefinition RightEar = Head.addOrReplaceChild("RightEar", CubeListBuilder.create().texOffs(200, 37).addBox(-1.0f, -8.0f, 0.0f, 1.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-9.0f, (float)-1.0f, (float)-6.0f, (float)0.1309f, (float)-0.48f, (float)0.0f));
        PartDefinition Tusks = Head.addOrReplaceChild("Tusks", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightTusk = Tusks.addOrReplaceChild("RightTusk", CubeListBuilder.create(), PartPose.offset((float)-7.0f, (float)6.0f, (float)-9.0f));
        PartDefinition RightTuskTop = RightTusk.addOrReplaceChild("RightTuskTop", CubeListBuilder.create().texOffs(192, 0).addBox(-15.0f, 0.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)14.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightTuskMiddle = RightTuskTop.addOrReplaceChild("RightTuskMiddle", CubeListBuilder.create().texOffs(204, 0).mirror().addBox(-15.0f, -0.35f, -1.05f, 2.0f, 6.0f, 2.0f, new CubeDeformation(-0.001f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition RightTuskBottom = RightTuskMiddle.addOrReplaceChild("RightTuskBottom", CubeListBuilder.create().texOffs(215, 0).addBox(-15.0f, -0.85f, -1.475f, 2.0f, 5.0f, 2.0f, new CubeDeformation(-0.002f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition LeftTusk = Tusks.addOrReplaceChild("LeftTusk", CubeListBuilder.create(), PartPose.offset((float)7.0f, (float)6.0f, (float)-9.0f));
        PartDefinition LeftTuskTop = LeftTusk.addOrReplaceChild("LeftTuskTop", CubeListBuilder.create().texOffs(192, 0).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftTuskMiddle = LeftTuskTop.addOrReplaceChild("LeftTuskMiddle", CubeListBuilder.create().texOffs(204, 0).addBox(-1.0f, -0.35f, -1.05f, 2.0f, 6.0f, 2.0f, new CubeDeformation(-0.001f)), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)0.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition LeftTuskBottom = LeftTuskMiddle.addOrReplaceChild("LeftTuskBottom", CubeListBuilder.create().texOffs(215, 0).mirror().addBox(-1.0f, -0.85f, -1.475f, 2.0f, 5.0f, 2.0f, new CubeDeformation(-0.002f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition RightFrontLeg = Body.addOrReplaceChild("RightFrontLeg", CubeListBuilder.create().texOffs(95, 0).addBox(-2.75f, 0.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)-19.0f, (float)-16.0f));
        PartDefinition LeftFrontLeg = Body.addOrReplaceChild("LeftFrontLeg", CubeListBuilder.create().texOffs(68, 0).addBox(-3.25f, 0.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)-19.0f, (float)-16.0f));
        PartDefinition LeftBackLeg = Body.addOrReplaceChild("LeftBackLeg", CubeListBuilder.create().texOffs(122, 0).addBox(-3.25f, 0.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)-19.0f, (float)16.0f));
        PartDefinition RightBackLeg = Body.addOrReplaceChild("RightBackLeg", CubeListBuilder.create().texOffs(149, 0).addBox(-2.75f, 0.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)-19.0f, (float)16.0f));
        PartDefinition Chests = Body.addOrReplaceChild("Chests", CubeListBuilder.create().texOffs(54, 38).addBox(11.0f, -36.0f, 9.5f, 2.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(54, 38).mirror().addBox(-13.0f, -36.0f, 9.5f, 2.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(127, 112).mirror().addBox(10.2f, -41.475f, 11.5f, 1.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(127, 112).addBox(-11.2f, -41.475f, 11.5f, 1.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(127, 105).addBox(-8.5f, -42.475f, 11.5f, 17.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition HolderLeft = Chests.addOrReplaceChild("HolderLeft", CubeListBuilder.create().texOffs(173, 104).addBox(-1.158f, 0.4397f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(-0.001f)), PartPose.offsetAndRotation((float)9.6f, (float)-42.5f, (float)13.5f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition HolderRight = Chests.addOrReplaceChild("HolderRight", CubeListBuilder.create().texOffs(173, 104).addBox(-1.842f, 0.4397f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(-0.001f)), PartPose.offsetAndRotation((float)-9.6f, (float)-42.5f, (float)13.5f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition Saddle = Body.addOrReplaceChild("Saddle", CubeListBuilder.create().texOffs(127, 112).addBox(-6.5f, -43.0f, -7.0f, 13.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(128, 100).addBox(-6.0f, -44.0f, 3.0f, 12.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(181, 113).addBox(-11.2f, -41.475f, -2.0f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(181, 113).mirror().addBox(10.2f, -41.475f, -2.0f, 1.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(168, 117).addBox(-1.5f, -45.0f, -7.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(245, 43).addBox(10.4f, -31.5f, -2.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(245, 43).addBox(-11.4f, -31.5f, -2.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(245, 43).addBox(10.375f, -31.0f, -2.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(245, 43).addBox(-11.375f, -31.0f, -2.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition SaddleRight = Saddle.addOrReplaceChild("SaddleRight", CubeListBuilder.create().texOffs(158, 100).addBox(-2.8499f, 0.8811f, -0.5f, 5.0f, 1.0f, 2.0f, new CubeDeformation(-0.001f)), PartPose.offsetAndRotation((float)-8.625f, (float)-43.175f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        PartDefinition SaddleLeft = Saddle.addOrReplaceChild("SaddleLeft", CubeListBuilder.create().texOffs(158, 100).mirror().addBox(-2.2485f, 0.8811f, -0.5f, 5.0f, 1.0f, 2.0f, new CubeDeformation(-0.001f)).mirror(false), PartPose.offsetAndRotation((float)8.725f, (float)-43.15f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.3054f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)128);
    }
}

