/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.block;

import com.tristankechlo.livingthings.entity.OstrichEntity;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OstrichNestBlock
extends Block
implements ILexiconEntry {
    public static final BooleanProperty EGG = BooleanProperty.create((String)"egg");
    public static final IntegerProperty HATCH = BlockStateProperties.HATCH;
    private static final VoxelShape EMPTY_NEST_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final VoxelShape FULL_NEST_SHAPE = Shapes.join((VoxelShape)EMPTY_NEST_SHAPE, (VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (BooleanOp)BooleanOp.OR);

    public OstrichNestBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY).strength(0.5f).randomTicks());
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HATCH, (Comparable)Integer.valueOf(0))).setValue((Property)EGG, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{EGG, HATCH});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        boolean hasEgg = (Boolean)state.getValue((Property)EGG);
        if (player.getMainHandItem().getItem() == ModItems.LEXICON.get()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (hasEgg && stack.isEmpty()) {
            world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)EGG, (Comparable)Boolean.valueOf(false))).setValue((Property)HATCH, (Comparable)Integer.valueOf(0)), 2);
            world.playSound(player, pos, ModSounds.OSTRICH_EGG_REMOVED.get(), SoundSource.BLOCKS, 0.7f, 0.9f);
            if (!world.isClientSide) {
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack((ItemLike)ModItems.OSTRICH_EGG.get()));
                itemEntity.setDefaultPickUpDelay();
                world.addFreshEntity((Entity)itemEntity);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (!hasEgg && stack.is(ModItems.OSTRICH_EGG.get())) {
            state = (BlockState)((BlockState)state.setValue((Property)EGG, (Comparable)Boolean.valueOf(true))).setValue((Property)HATCH, (Comparable)Integer.valueOf(0));
            world.setBlock(pos, state, 2);
            world.playSound(player, pos, SoundEvents.SWEET_BERRY_BUSH_PLACE, SoundSource.BLOCKS, 0.7f, 0.9f);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, world, pos, player, handIn, hit);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)EGG)).booleanValue()) {
            return;
        }
        if (this.canGrow((Level)worldIn)) {
            int i = (Integer)state.getValue((Property)HATCH);
            if (i < 2) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
                worldIn.playSound(null, pos, ModSounds.OSTRICH_EGG_CRACKS.get(), SoundSource.BLOCKS, 0.7f, 0.9f);
            } else {
                worldIn.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)EGG, (Comparable)Boolean.valueOf(false))).setValue((Property)HATCH, (Comparable)Integer.valueOf(0)), 2);
                worldIn.playSound(null, pos, ModSounds.OSTRICH_EGG_CRACKS.get(), SoundSource.BLOCKS, 0.7f, 0.9f);
                OstrichEntity ostrichEntity = (OstrichEntity)ModEntityTypes.OSTRICH.get().create((Level)worldIn);
                ostrichEntity.setAge(-24000);
                ostrichEntity.setPosRaw((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                worldIn.addFreshEntity((Entity)ostrichEntity);
            }
        }
    }

    private boolean canGrow(Level world) {
        float f = world.getTimeOfDay(1.0f);
        if (f < 0.7f && f > 0.6f) {
            return true;
        }
        return world.random.nextInt(175) == 0;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)EGG) != false ? FULL_NEST_SHAPE : EMPTY_NEST_SHAPE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.OSTRICH_NEST_BLOCK;
    }
}

