/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.processor.RandomSettings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public class ApplyRandomStructureProcessor
extends StructureProcessor {
    private static final Codec<SimpleWeightedRandomList<Holder<StructureProcessorList>>> WEIGHTED_LIST_CODEC = SimpleWeightedRandomList.wrappedCodecAllowingEmpty((Codec)StructureProcessorType.LIST_CODEC);
    private static final Codec<HolderSet<StructureProcessorList>> SET_CODEC = RegistryCodecs.homogeneousList((ResourceKey)Registries.PROCESSOR_LIST, (Codec)StructureProcessorType.DIRECT_CODEC);
    public static final MapCodec<ApplyRandomStructureProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.withAlternative(SET_CODEC, WEIGHTED_LIST_CODEC, ApplyRandomStructureProcessor::convertToSet).fieldOf("processor_lists").forGetter(ApplyRandomStructureProcessor::processorLists), (App)RandomSettings.CODEC.fieldOf("mode").forGetter(ApplyRandomStructureProcessor::randomSettings)).apply((Applicative)instance, ApplyRandomStructureProcessor::new));
    public static final StructureProcessorType<ApplyRandomStructureProcessor> TYPE = () -> CODEC;
    private final HolderSet<StructureProcessorList> processorLists;
    private final RandomSettings randomSettings;

    private static HolderSet<StructureProcessorList> convertToSet(SimpleWeightedRandomList<Holder<StructureProcessorList>> weightedList) {
        ArrayList<Holder> holders = new ArrayList<Holder>();
        for (WeightedEntry.Wrapper processor : weightedList.unwrap()) {
            for (int i = 0; i < processor.getWeight().asInt(); ++i) {
                holders.add((Holder)processor.data());
            }
        }
        return HolderSet.direct(holders);
    }

    public ApplyRandomStructureProcessor(HolderSet<StructureProcessorList> processorLists, RandomSettings randomSettings) {
        this.processorLists = processorLists;
        this.randomSettings = randomSettings;
    }

    public HolderSet<StructureProcessorList> processorLists() {
        return this.processorLists;
    }

    public RandomSettings randomSettings() {
        return this.randomSettings;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos pivot, StructureTemplate.StructureBlockInfo relative, StructureTemplate.StructureBlockInfo absolute, StructurePlaceSettings settings) {
        WorldGenLevel level;
        RandomSource random;
        Optional processorList;
        if (levelReader instanceof WorldGenLevel && (processorList = this.processorLists.getRandomElement(random = this.randomSettings.create(level = (WorldGenLevel)levelReader, pos, absolute))).isPresent()) {
            StructureProcessor processor;
            StructureTemplate.StructureBlockInfo processedBlock = absolute;
            Iterator iterator = ((StructureProcessorList)((Holder)processorList.get()).value()).list().iterator();
            while (iterator.hasNext() && (processedBlock = (processor = (StructureProcessor)iterator.next()).processBlock(levelReader, pos, pivot, relative, processedBlock, settings)) != null) {
            }
            return processedBlock;
        }
        return absolute;
    }

    @NotNull
    protected StructureProcessorType<?> getType() {
        return TYPE;
    }
}

