/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.block.Block;

public interface LithostitchedCodecs {
    public static final Codec<HolderSet<Block>> BLOCK_SET = RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK);
    public static final MapCodec<Float> CHANCE = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance");

    public static <T> MapCodec<HolderSet<T>> registrySet(ResourceKey<Registry<T>> registry, String name) {
        return RegistryCodecs.homogeneousList(registry).fieldOf(name);
    }

    public static <E> Codec<List<E>> compactList(Codec<E> codec) {
        return Codec.either((Codec)codec.listOf(), codec).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right(list.getFirst()) : Either.left((Object)list));
    }

    public static <T> Codec<SimpleWeightedRandomList<T>> singleOrWeightedList(Codec<T> codec, boolean allowsEmpty) {
        Codec weightedListCodec = allowsEmpty ? SimpleWeightedRandomList.wrappedCodecAllowingEmpty(codec) : SimpleWeightedRandomList.wrappedCodec(codec);
        return Codec.withAlternative((Codec)weightedListCodec, codec, SimpleWeightedRandomList::single);
    }
}

