/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.neoforge.terraform.boat.impl.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import de.cristelknight.doapi.client.terraform.TerraformBoatClientHelper;
import de.cristelknight.doapi.neoforge.terraform.boat.api.TerraformBoatTypeRegistry;
import de.cristelknight.doapi.neoforge.terraform.boat.impl.entity.TerraformBoatHolder;
import de.cristelknight.doapi.terraform.boat.TerraformBoatType;
import java.util.Map;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChestRaftModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.RaftModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class CustomBoatEntityRenderer
extends BoatRenderer {
    private final Map<TerraformBoatType, Pair<ResourceLocation, ListModel<Boat>>> texturesAndModels = (Map)TerraformBoatTypeRegistry.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getValue, entry -> {
        boolean raft = ((TerraformBoatType)entry.getValue()).isRaft();
        String prefix = raft ? (chest ? "chest_raft/" : "raft/") : (chest ? "chest_boat/" : "boat/");
        ResourceLocation id = (ResourceLocation)entry.getKey();
        ResourceLocation textureId = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("textures/entity/" + prefix + id.getPath() + ".png"));
        ModelLayerLocation layer = TerraformBoatClientHelper.getLayer(id, raft, chest);
        ListModel<Boat> model = this.createModel(context.bakeLayer(layer), raft, chest);
        return new Pair((Object)textureId, model);
    }));

    public CustomBoatEntityRenderer(EntityRendererProvider.Context context, boolean chest) {
        super(context, chest);
    }

    public void render(@NotNull Boat boat, float f, float g, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int i) {
        if (boat instanceof TerraformBoatHolder) {
            TerraformBoatHolder myHolder = (TerraformBoatHolder)boat;
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.375f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - f));
            float h = (float)boat.getHurtTime() - g;
            float j = boat.getDamage() - g;
            if (j < 0.0f) {
                j = 0.0f;
            }
            if (h > 0.0f) {
                poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)h) * h * j / 10.0f * (float)boat.getHurtDir()));
            }
            if (!Mth.equal((float)boat.getBubbleAngle(g), (float)0.0f)) {
                poseStack.mulPose(new Quaternionf().setAngleAxis(boat.getBubbleAngle(g) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
            }
            Pair<ResourceLocation, ListModel<Boat>> pair = this.getTextureAndModel(myHolder);
            ResourceLocation resourceLocation = (ResourceLocation)pair.getFirst();
            ListModel listModel = (ListModel)pair.getSecond();
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            listModel.setupAnim((Entity)boat, g, 0.0f, -0.1f, 0.0f, 0.0f);
            VertexConsumer vertexConsumer = multiBufferSource.getBuffer(listModel.renderType(resourceLocation));
            listModel.renderToBuffer(poseStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY);
            if (!boat.isUnderWater()) {
                VertexConsumer vertexConsumer2 = multiBufferSource.getBuffer(RenderType.waterMask());
                if (listModel instanceof WaterPatchModel) {
                    WaterPatchModel waterPatchModel = (WaterPatchModel)listModel;
                    waterPatchModel.waterPatch().render(poseStack, vertexConsumer2, i, OverlayTexture.NO_OVERLAY);
                }
            }
            poseStack.popPose();
        } else {
            super.render(boat, f, g, poseStack, multiBufferSource, i);
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Boat entity) {
        if (entity instanceof TerraformBoatHolder) {
            TerraformBoatType boat = ((TerraformBoatHolder)entity).getTerraformBoat();
            return (ResourceLocation)this.texturesAndModels.get(boat).getFirst();
        }
        return super.getTextureLocation(entity);
    }

    public Pair<ResourceLocation, ListModel<Boat>> getTextureAndModel(TerraformBoatHolder holder) {
        return this.texturesAndModels.get(holder.getTerraformBoat());
    }

    private ListModel<Boat> createModel(ModelPart part, boolean raft, boolean chest) {
        if (raft) {
            return chest ? new ChestRaftModel(part) : new RaftModel(part);
        }
        return chest ? new ChestBoatModel(part) : new BoatModel(part);
    }
}

