/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.registry;

import de.cristelknight.doapi.DoApiRL;
import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.common.block.StandardBlock;
import de.cristelknight.doapi.common.block.StandardWallBlock;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;

public class DoApiBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"doapi", (ResourceKey)Registries.BLOCK);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final Supplier<Block> STANDARD = DoApiBlocks.registerWithoutItem("standard", () -> new StandardBlock(DoApiBlocks.properties(1.0f).instrument(NoteBlockInstrument.BASS).noCollission().sound(SoundType.WOOD)));
    public static final Supplier<Block> WALL_STANDARD = DoApiBlocks.registerWithoutItem("wall_standard", () -> new StandardWallBlock(DoApiBlocks.properties(1.0f).instrument(NoteBlockInstrument.BASS).noCollission().sound(SoundType.WOOD).dropsLike(STANDARD.get())));

    public static void init() {
        BLOCKS.register();
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return Util.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, DoApiRL.asResourceLocation(path), block);
    }

    public static BlockBehaviour.Properties properties(float strength) {
        return DoApiBlocks.properties(strength, strength);
    }

    public static BlockBehaviour.Properties properties(float breakSpeed, float explosionResist) {
        return BlockBehaviour.Properties.of().strength(breakSpeed, explosionResist);
    }
}

