/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.block;

import de.cristelknight.doapi.common.util.ChairUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChairBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SINGLE_SHAPE = ChairBlock.makeSingleShape();
    private static final VoxelShape[] SHAPE = new VoxelShape[]{Block.box((double)3.0, (double)10.0, (double)11.0, (double)13.0, (double)22.0, (double)13.0), Block.box((double)11.0, (double)10.0, (double)3.0, (double)13.0, (double)22.0, (double)13.0), Block.box((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)22.0, (double)5.0), Block.box((double)3.0, (double)10.0, (double)3.0, (double)5.0, (double)22.0, (double)13.0)};

    public ChairBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected static VoxelShape makeSingleShape() {
        VoxelShape top = Block.box((double)3.0, (double)9.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
        VoxelShape leg1 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)5.0, (double)9.0, (double)5.0);
        VoxelShape leg2 = Block.box((double)3.0, (double)0.0, (double)11.0, (double)5.0, (double)9.0, (double)13.0);
        VoxelShape leg3 = Block.box((double)11.0, (double)0.0, (double)11.0, (double)13.0, (double)9.0, (double)13.0);
        VoxelShape leg4 = Block.box((double)11.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)5.0);
        return Shapes.or((VoxelShape)top, (VoxelShape[])new VoxelShape[]{leg1, leg2, leg3, leg4});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            default: {
                return Shapes.or((VoxelShape)SINGLE_SHAPE, (VoxelShape)SHAPE[0]);
            }
            case WEST: {
                return Shapes.or((VoxelShape)SINGLE_SHAPE, (VoxelShape)SHAPE[1]);
            }
            case SOUTH: {
                return Shapes.or((VoxelShape)SINGLE_SHAPE, (VoxelShape)SHAPE[2]);
            }
            case EAST: 
        }
        return Shapes.or((VoxelShape)SINGLE_SHAPE, (VoxelShape)SHAPE[3]);
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        return ChairUtil.onUse(level, player, player.getUsedItemHand(), blockHitResult, 0.1);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        super.onRemove(state, world, pos, newState, moved);
        ChairUtil.onStateReplaced(world, pos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

