/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.recipebook.screen.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PrivateRecipeGroupButtonWidget
extends StateSwitchingButton {
    private static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/tab"), ResourceLocation.withDefaultNamespace((String)"recipe_book/tab_selected"));
    private final IRecipeBookGroup group;
    private float bounce;

    public PrivateRecipeGroupButtonWidget(IRecipeBookGroup group) {
        super(0, 0, 35, 27, false);
        this.group = group;
        this.initTextureValues(SPRITES);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.sprites == null) {
            return;
        }
        if (this.bounce > 0.0f) {
            float g = 1.0f + 0.1f * (float)Math.sin(this.bounce / 15.0f * (float)Math.PI);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(this.getX() + 8), (float)(this.getY() + 12), 0.0f);
            guiGraphics.pose().scale(1.0f, g, 1.0f);
            guiGraphics.pose().translate((float)(-(this.getX() + 8)), (float)(-(this.getY() + 12)), 0.0f);
        }
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.disableDepthTest();
        ResourceLocation resourceLocation = this.sprites.get(true, this.isStateTriggered);
        int k = this.getX();
        if (this.isStateTriggered) {
            k -= 2;
        }
        guiGraphics.blitSprite(resourceLocation, k, this.getY(), this.width, this.height);
        RenderSystem.enableDepthTest();
        this.renderIcons(guiGraphics);
        if (this.bounce > 0.0f) {
            guiGraphics.pose().popPose();
            this.bounce -= delta;
        }
    }

    private void renderIcons(GuiGraphics guiGraphics) {
        int i;
        List<ItemStack> list = this.group.getIcons();
        int n = i = this.isStateTriggered ? -2 : 0;
        if (list.size() == 1) {
            guiGraphics.renderItem(list.get(0), this.getX() + 9 + i, this.getY() + 5);
        } else if (list.size() == 2) {
            guiGraphics.renderItem(list.get(0), this.getX() + 3 + i, this.getY() + 5);
            guiGraphics.renderItem(list.get(1), this.getX() + 14 + i, this.getY() + 5);
        }
    }

    public IRecipeBookGroup getGroup() {
        return this.group;
    }
}

