/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.recipebook.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.cristelknight.doapi.client.recipebook.handler.AbstractPrivateRecipeScreenHandler;
import de.cristelknight.doapi.client.recipebook.screen.widgets.PrivateAnimatedResultButton;
import de.cristelknight.doapi.client.recipebook.screen.widgets.PrivateRecipeAlternativesWidget;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PrivateRecipeBookRecipeArea {
    private static final WidgetSprites PAGE_FORWARD_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/page_forward"), ResourceLocation.withDefaultNamespace((String)"recipe_book/page_forward_highlighted"));
    private static final WidgetSprites PAGE_BACKWARD_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/page_backward"), ResourceLocation.withDefaultNamespace((String)"recipe_book/page_backward_highlighted"));
    private final List<PrivateAnimatedResultButton> resultButtons = Lists.newArrayListWithCapacity((int)20);
    @Nullable
    private PrivateAnimatedResultButton hoveredResultButton;
    private final PrivateRecipeAlternativesWidget alternatesWidget = new PrivateRecipeAlternativesWidget();
    private Minecraft client;
    private List<? extends Recipe<RecipeInput>> resultCollections = ImmutableList.of();
    private StateSwitchingButton nextPageButton;
    private StateSwitchingButton prevPageButton;
    private int pageCount;
    private int currentPage;
    @Nullable
    private Recipe<?> lastClickedRecipe;
    private AbstractPrivateRecipeScreenHandler recipeScreenHandler;

    public PrivateRecipeBookRecipeArea() {
        for (int i = 0; i < 20; ++i) {
            this.resultButtons.add(new PrivateAnimatedResultButton());
        }
    }

    public void initialize(Minecraft client, int parentLeft, int parentTop, AbstractPrivateRecipeScreenHandler recipeScreenHandler) {
        this.client = client;
        this.recipeScreenHandler = recipeScreenHandler;
        for (int i = 0; i < this.resultButtons.size(); ++i) {
            this.resultButtons.get(i).setPos(parentLeft + 11 + 25 * (i % 5), parentTop + 31 + 25 * (i / 5));
        }
        this.nextPageButton = new StateSwitchingButton(parentLeft + 93, parentTop + 137, 12, 17, false);
        this.nextPageButton.initTextureValues(PAGE_FORWARD_SPRITES);
        this.prevPageButton = new StateSwitchingButton(parentLeft + 38, parentTop + 137, 12, 17, true);
        this.prevPageButton.initTextureValues(PAGE_BACKWARD_SPRITES);
    }

    public void setResults(List<? extends Recipe<RecipeInput>> resultCollections, boolean resetCurrentPage) {
        this.resultCollections = resultCollections;
        this.pageCount = (int)Math.ceil((double)resultCollections.size() / 20.0);
        if (this.pageCount <= this.currentPage || resetCurrentPage) {
            this.currentPage = 0;
        }
        this.refreshResultButtons();
    }

    private void refreshResultButtons() {
        int i = 20 * this.currentPage;
        for (int j = 0; j < this.resultButtons.size(); ++j) {
            PrivateAnimatedResultButton animatedResultButton = this.resultButtons.get(j);
            if (i + j < this.resultCollections.size()) {
                Recipe<RecipeInput> recipe = this.resultCollections.get(i + j);
                animatedResultButton.showResultCollection(recipe, this.recipeScreenHandler);
                animatedResultButton.visible = true;
                continue;
            }
            animatedResultButton.visible = false;
        }
        this.hideShowPageButtons();
    }

    private void hideShowPageButtons() {
        this.nextPageButton.visible = this.pageCount > 1 && this.currentPage < this.pageCount - 1;
        this.prevPageButton.visible = this.pageCount > 1 && this.currentPage > 0;
    }

    public void draw(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float delta) {
        if (this.pageCount > 1) {
            int var10000 = this.currentPage + 1;
            String string = var10000 + "/" + this.pageCount;
            int i = this.client.font.width(string);
            guiGraphics.drawString(this.client.font, string, x - i / 2 + 73, y + 141, -1, false);
        }
        this.hoveredResultButton = null;
        for (PrivateAnimatedResultButton animatedResultButton : this.resultButtons) {
            animatedResultButton.render(guiGraphics, mouseX, mouseY, delta);
            if (!animatedResultButton.visible || !animatedResultButton.isHoveredOrFocused()) continue;
            this.hoveredResultButton = animatedResultButton;
        }
        this.prevPageButton.render(guiGraphics, mouseX, mouseY, delta);
        this.nextPageButton.render(guiGraphics, mouseX, mouseY, delta);
        this.alternatesWidget.render(guiGraphics, mouseX, mouseY, delta);
    }

    public void drawTooltip(GuiGraphics guiGraphics, int x, int y) {
        if (this.client.screen != null && this.hoveredResultButton != null && !this.alternatesWidget.isVisible()) {
            guiGraphics.renderComponentTooltip(this.client.font, this.hoveredResultButton.getOutputTooltip(), x, y);
        }
    }

    @Nullable
    public Recipe<?> getLastClickedRecipe() {
        return this.lastClickedRecipe;
    }

    public void hideAlternates() {
        this.alternatesWidget.setVisible(false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        PrivateAnimatedResultButton animatedResultButton;
        this.lastClickedRecipe = null;
        if (this.alternatesWidget.isVisible()) {
            if (this.alternatesWidget.mouseClicked(mouseX, mouseY, button)) {
                this.lastClickedRecipe = this.alternatesWidget.getLastClickedRecipe();
            } else {
                this.alternatesWidget.setVisible(false);
            }
            return true;
        }
        if (this.nextPageButton.mouseClicked(mouseX, mouseY, button)) {
            ++this.currentPage;
            this.refreshResultButtons();
            return true;
        }
        if (this.prevPageButton.mouseClicked(mouseX, mouseY, button)) {
            --this.currentPage;
            this.refreshResultButtons();
            return true;
        }
        Iterator<PrivateAnimatedResultButton> var10 = this.resultButtons.iterator();
        do {
            if (var10.hasNext()) continue;
            return false;
        } while (!(animatedResultButton = var10.next()).mouseClicked(mouseX, mouseY, button));
        if (button == 0) {
            this.lastClickedRecipe = animatedResultButton.currentRecipe();
        }
        if (button != 1 || this.alternatesWidget.isVisible() || animatedResultButton.hasResult()) {
            // empty if block
        }
        return true;
    }

    public Minecraft getClient() {
        return this.client;
    }
}

