/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.recipebook.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.cristelknight.doapi.DoApiRL;
import de.cristelknight.doapi.client.recipebook.handler.AbstractPrivateRecipeScreenHandler;
import de.cristelknight.doapi.client.recipebook.screen.widgets.PrivateRecipeBookWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractRecipeBookGUIScreen<T extends AbstractPrivateRecipeScreenHandler>
extends AbstractContainerScreen<T> {
    private final ResourceLocation BACKGROUND;
    private static final ResourceLocation RECIPE_BUTTON_TEXTURE = DoApiRL.asResourceLocation("textures/gui/recipe_button.png");
    private static final WidgetSprites DOAPI_RECIPE_BUTTON = new WidgetSprites(DoApiRL.asResourceLocation("recipe_book/button"), DoApiRL.asResourceLocation("recipe_book/button_highlighted"));
    public final PrivateRecipeBookWidget recipeBook;
    private boolean narrow;

    public AbstractRecipeBookGUIScreen(T handler, Inventory inventory, Component title, PrivateRecipeBookWidget recipeBook, ResourceLocation background) {
        super(handler, inventory, title);
        this.BACKGROUND = background;
        this.recipeBook = recipeBook;
    }

    protected void init() {
        super.init();
        this.narrow = this.width < 379;
        this.recipeBook.initialize(this.width, this.height, this.minecraft, this.narrow, (AbstractPrivateRecipeScreenHandler)this.menu);
        this.leftPos = this.recipeBook.findLeftEdge(this.width, this.imageWidth);
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.topPos + 25, 20, 18, DOAPI_RECIPE_BUTTON, button -> {
            this.recipeBook.toggleOpen();
            this.leftPos = this.recipeBook.findLeftEdge(this.width, this.imageWidth);
            button.setPosition(this.leftPos + 5, this.topPos + 25);
        }));
        this.titleLabelX += 20;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        if (this.recipeBook.isOpen() && this.narrow) {
            this.renderBg(guiGraphics, delta, mouseX, mouseY);
            this.recipeBook.render(guiGraphics, mouseX, mouseY, delta);
        } else {
            this.recipeBook.render(guiGraphics, mouseX, mouseY, delta);
            super.render(guiGraphics, mouseX, mouseY, delta);
            this.recipeBook.drawGhostSlots(guiGraphics, this.leftPos, this.topPos, true, delta);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.recipeBook.drawTooltip(guiGraphics, this.leftPos, this.topPos, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.BACKGROUND);
        int posX = this.leftPos;
        int posY = this.topPos;
        guiGraphics.blit(this.BACKGROUND, posX, posY, 0, 0, this.imageWidth - 1, this.imageHeight);
        this.renderProgressArrow(guiGraphics);
        this.renderBurnIcon(guiGraphics, posX, posY);
    }

    protected void renderProgressArrow(GuiGraphics guiGraphics) {
    }

    protected void renderBurnIcon(GuiGraphics guiGraphics, int posX, int posY) {
    }

    protected void containerTick() {
        super.containerTick();
        this.recipeBook.update();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.recipeBook.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return this.narrow && this.recipeBook.isOpen() || super.mouseClicked(mouseX, mouseY, button);
    }

    protected void slotClicked(Slot slot, int slotId, int button, ClickType actionType) {
        super.slotClicked(slot, slotId, button, actionType);
        this.recipeBook.slotClicked(slot);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return !this.recipeBook.keyPressed(keyCode, scanCode, modifiers) && super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int left, int top, int button) {
        boolean bl = mouseX < (double)left || mouseY < (double)top || mouseX >= (double)(left + this.imageWidth) || mouseY >= (double)(top + this.imageHeight);
        return this.recipeBook.isClickOutsideBounds(mouseX, mouseY, this.leftPos, this.topPos, this.imageWidth, this.imageHeight) && bl;
    }

    public boolean charTyped(char chr, int modifiers) {
        return this.recipeBook.charTyped(chr, modifiers) || super.charTyped(chr, modifiers);
    }

    public void removed() {
        super.removed();
    }
}

