/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.handler;

import com.direwolf20.laserio.common.containers.CardItemContainer;
import com.direwolf20.laserio.common.containers.FilterBasicContainer;
import com.direwolf20.laserio.common.containers.FilterCountContainer;
import com.direwolf20.laserio.common.containers.FilterNBTContainer;
import com.direwolf20.laserio.common.containers.FilterTagContainer;
import com.direwolf20.laserio.common.items.filters.FilterBasic;
import com.direwolf20.laserio.common.items.filters.FilterCount;
import com.direwolf20.laserio.common.items.filters.FilterNBT;
import com.direwolf20.laserio.common.items.filters.FilterTag;
import com.direwolf20.laserio.common.network.data.OpenFilterPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PacketOpenFilter {
    public static final PacketOpenFilter INSTANCE = new PacketOpenFilter();

    public static PacketOpenFilter get() {
        return INSTANCE;
    }

    public static void doOpenFilter(final ItemStack filterItem, final ItemStack cardItem, final ServerPlayer sender, final BlockPos sourcePos) {
        Object containerProvider;
        if (filterItem.getItem() instanceof FilterBasic) {
            containerProvider = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"screen.laserio.lasernode");
                }

                public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                    return false;
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                    return new FilterBasicContainer(windowId, playerInventory, (Player)sender, sourcePos, filterItem, cardItem);
                }
            };
            sender.openMenu(containerProvider, buf -> {
                ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)filterItem);
                ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)cardItem);
            });
        }
        if (filterItem.getItem() instanceof FilterCount) {
            containerProvider = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"screen.laserio.lasernode");
                }

                public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                    return false;
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                    return new FilterCountContainer(windowId, playerInventory, (Player)sender, sourcePos, filterItem, cardItem);
                }
            };
            sender.openMenu(containerProvider, buf -> {
                ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)filterItem);
                ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)cardItem);
            });
        }
        if (filterItem.getItem() instanceof FilterTag) {
            containerProvider = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"screen.laserio.lasernode");
                }

                public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                    return false;
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                    return new FilterTagContainer(windowId, playerInventory, (Player)sender, sourcePos, filterItem, cardItem);
                }
            };
            sender.openMenu(containerProvider, buf -> {
                ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)filterItem);
                ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)ItemStack.EMPTY);
            });
        }
        if (filterItem.getItem() instanceof FilterNBT) {
            containerProvider = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"screen.laserio.lasernode");
                }

                public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                    return false;
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                    return new FilterNBTContainer(windowId, playerInventory, (Player)sender, sourcePos, filterItem, cardItem);
                }
            };
            sender.openMenu(containerProvider, buf -> {
                ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)filterItem);
                ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)ItemStack.EMPTY);
            });
        }
    }

    public void handle(OpenFilterPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player sender = context.player();
            AbstractContainerMenu container = sender.containerMenu;
            if (container == null || !(container instanceof CardItemContainer)) {
                return;
            }
            Slot slot = (Slot)container.slots.get(payload.slotNumber());
            ItemStack itemStack = slot.getItem();
            PacketOpenFilter.doOpenFilter(itemStack, ((CardItemContainer)container).cardItem, (ServerPlayer)sender, ((CardItemContainer)container).sourceContainer);
        });
    }
}

