/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import org.jetbrains.annotations.Nullable;

public interface NBTIOWrapper {
    @Nullable
    public static CompoundTag read(Path path) throws IOException {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return null;
        }
        return NbtIo.readCompressed((InputStream)Files.newInputStream(path, new OpenOption[0]), (NbtAccounter)NbtAccounter.unlimitedHeap());
    }

    public static void write(Path path, CompoundTag nbt) throws IOException {
        if (nbt == null) {
            Files.deleteIfExists(path);
            return;
        }
        NbtIo.writeCompressed((CompoundTag)nbt, (OutputStream)Files.newOutputStream(path, new OpenOption[0]));
    }
}

