/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.serialization.Codec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public interface IconKJS {
    public static final IconKJS NONE = new IconKJS(){};
    public static final Codec<IconKJS> CODEC = Codec.unit((Object)NONE);
    public static final StreamCodec<RegistryFriendlyByteBuf, IconKJS> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, IconKJS>(){

        public void encode(RegistryFriendlyByteBuf buf, IconKJS icon) {
            if (icon == NONE) {
                buf.writeByte(0);
            } else if (icon instanceof FromTexture) {
                FromTexture t = (FromTexture)icon;
                buf.writeByte(1);
                buf.writeResourceLocation(t.texture);
            } else if (icon instanceof FromItem) {
                FromItem i = (FromItem)icon;
                buf.writeByte(2);
                ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)i.stack);
            } else if (icon instanceof FromAtlasSprite) {
                FromAtlasSprite s = (FromAtlasSprite)icon;
                if (s.atlas.equals((Object)InventoryMenu.BLOCK_ATLAS)) {
                    buf.writeByte(3);
                    buf.writeResourceLocation(s.icon);
                } else {
                    buf.writeByte(4);
                    buf.writeResourceLocation(s.atlas);
                    buf.writeResourceLocation(s.icon);
                }
            } else {
                throw new IllegalArgumentException("Unknown icon type: " + String.valueOf(icon));
            }
        }

        public IconKJS decode(RegistryFriendlyByteBuf buf) {
            return switch (buf.readByte()) {
                case 1 -> new FromTexture(buf.readResourceLocation());
                case 2 -> new FromItem((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf));
                case 3 -> new FromAtlasSprite(InventoryMenu.BLOCK_ATLAS, buf.readResourceLocation());
                case 4 -> new FromAtlasSprite(buf.readResourceLocation(), buf.readResourceLocation());
                default -> NONE;
            };
        }
    };

    @OnlyIn(value=Dist.CLIENT)
    default public void draw(Minecraft mc, GuiGraphics graphics, int x, int y, int size) {
    }

    public record FromAtlasSprite(ResourceLocation atlas, ResourceLocation icon) implements IconKJS
    {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void draw(Minecraft mc, GuiGraphics graphics, int x, int y, int size) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)mc.getTextureAtlas(this.atlas).apply(this.icon);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Matrix4f m = graphics.pose().last().pose();
            int p0 = -size / 2;
            int p1 = p0 + size;
            float u0 = sprite.getU0();
            float v0 = sprite.getV0();
            float u1 = sprite.getU1();
            float v1 = sprite.getV1();
            BufferBuilder buf = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            buf.addVertex(m, (float)(x + p0), (float)(y + p1), 0.0f).setUv(u0, v1).setColor(255, 255, 255, 255);
            buf.addVertex(m, (float)(x + p1), (float)(y + p1), 0.0f).setUv(u1, v1).setColor(255, 255, 255, 255);
            buf.addVertex(m, (float)(x + p1), (float)(y + p0), 0.0f).setUv(u1, v0).setColor(255, 255, 255, 255);
            buf.addVertex(m, (float)(x + p0), (float)(y + p0), 0.0f).setUv(u0, v0).setColor(255, 255, 255, 255);
            BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        }
    }

    public record FromItem(ItemStack stack) implements IconKJS
    {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void draw(Minecraft mc, GuiGraphics graphics, int x, int y, int size) {
            Matrix4fStack m = RenderSystem.getModelViewStack();
            m.pushMatrix();
            m.translate((float)x - 2.0f, (float)y + 2.0f, 0.0f);
            float s = (float)size / 16.0f;
            m.scale(s, s, s);
            RenderSystem.applyModelViewMatrix();
            graphics.renderFakeItem(this.stack, -8, -8);
            m.popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public record FromTexture(ResourceLocation texture) implements IconKJS
    {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void draw(Minecraft mc, GuiGraphics graphics, int x, int y, int size) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Matrix4f m = graphics.pose().last().pose();
            int p0 = -size / 2;
            int p1 = p0 + size;
            BufferBuilder buf = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            buf.addVertex(m, (float)(x + p0), (float)(y + p1), 0.0f).setUv(0.0f, 1.0f).setColor(255, 255, 255, 255);
            buf.addVertex(m, (float)(x + p1), (float)(y + p1), 0.0f).setUv(1.0f, 1.0f).setColor(255, 255, 255, 255);
            buf.addVertex(m, (float)(x + p1), (float)(y + p0), 0.0f).setUv(1.0f, 0.0f).setColor(255, 255, 255, 255);
            buf.addVertex(m, (float)(x + p0), (float)(y + p0), 0.0f).setUv(0.0f, 0.0f).setColor(255, 255, 255, 255);
            BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        }
    }
}

