/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.viewer;

import dev.latvian.mods.kubejs.core.FluidKJS;
import dev.latvian.mods.kubejs.fluid.FluidWrapper;
import dev.latvian.mods.kubejs.item.ItemPredicate;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.util.Lazy;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import org.jetbrains.annotations.Nullable;

public class RecipeViewerEntryType {
    public static final RecipeViewerEntryType ITEM = new RecipeViewerEntryType("item", (Component)new Component<ItemStack>(ItemStackJS.TYPE_INFO, ItemStack.STREAM_CODEC, ItemStack::isEmpty), (Component)new Component<Ingredient>(ItemPredicate.TYPE_INFO, Ingredient.CONTENTS_STREAM_CODEC, Ingredient::isEmpty), (Component)new Component<Item>(ItemStackJS.ITEM_TYPE_INFO, ByteBufCodecs.registry((ResourceKey)Registries.ITEM), i -> i == Items.AIR)){

        @Override
        public Object wrapEntry(Context cx, Object from) {
            return ItemStackJS.wrap(RegistryAccessContainer.of(cx), from);
        }

        @Override
        public Object wrapPredicate(Context cx, Object from) {
            return ItemPredicate.wrap(cx, from);
        }

        @Override
        public Object getBase(Object from) {
            return ((ItemStack)from).getItem();
        }
    };
    public static final RecipeViewerEntryType FLUID = new RecipeViewerEntryType("fluid", (Component)new Component<FluidStack>(FluidWrapper.TYPE_INFO, FluidStack.STREAM_CODEC, FluidStack::isEmpty), (Component)new Component<FluidIngredient>(FluidWrapper.INGREDIENT_TYPE_INFO, FluidIngredient.STREAM_CODEC, FluidIngredient::isEmpty), (Component)new Component<Fluid>(FluidWrapper.FLUID_TYPE_INFO, ByteBufCodecs.registry((ResourceKey)Registries.FLUID), FluidKJS::kjs$isEmpty)){

        @Override
        public Object wrapEntry(Context cx, Object from) {
            return FluidWrapper.wrap(RegistryAccessContainer.of(cx), from);
        }

        @Override
        public Object wrapPredicate(Context cx, Object from) {
            return FluidWrapper.wrapIngredient(RegistryAccessContainer.of(cx), from);
        }

        @Override
        public Object getBase(Object from) {
            return ((FluidStack)from).getFluid();
        }
    };
    public static Lazy<Map<String, RecipeViewerEntryType>> CUSTOM_TYPES = Lazy.of(() -> {
        HashMap map = new HashMap();
        KubeJSPlugins.forEachPlugin(t -> map.put(t.id, t), KubeJSPlugin::registerRecipeViewerEntryTypes);
        return Map.copyOf(map);
    });
    public static final Lazy<List<RecipeViewerEntryType>> ALL_TYPES = Lazy.of(() -> {
        ArrayList<RecipeViewerEntryType> list = new ArrayList<RecipeViewerEntryType>();
        list.add(ITEM);
        list.add(FLUID);
        list.addAll(CUSTOM_TYPES.get().values());
        return List.copyOf(list);
    });
    public final String id;
    public final Component<?> entryType;
    public final Component<?> predicateType;
    public final Component<?> baseClass;

    public static RecipeViewerEntryType fromString(@Nullable Object id) {
        String string = id == null ? "" : id.toString();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"", "item", "fluid"}, (Object)string, n)) {
            case -1 -> null;
            case 0 -> null;
            case 1 -> ITEM;
            case 2 -> FLUID;
            default -> CUSTOM_TYPES.get().get(String.valueOf(id));
        };
    }

    public RecipeViewerEntryType(String id, Component<?> entryType, Component<?> predicateType, @Nullable Component<?> baseClass) {
        this.id = id;
        this.entryType = entryType;
        this.predicateType = predicateType;
        this.baseClass = baseClass;
    }

    public Object wrapEntry(Context cx, Object from) {
        return cx.jsToJava(from, this.entryType.type);
    }

    public Object wrapPredicate(Context cx, Object from) {
        return cx.jsToJava(from, this.predicateType.type);
    }

    public Object getBase(Object from) {
        return from;
    }

    public record Component<T>(TypeInfo type, StreamCodec<?, T> streamCodec, Predicate<T> empty) {
    }
}

