/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.StringReader;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.fluid.FluidWrapper;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.schema.RecipeComponentFactory;
import dev.latvian.mods.kubejs.registry.RegistryType;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public record RegistryComponent<T>(Registry<T> registry, @Nullable RegistryType<T> regType, Codec<T> codec) implements RecipeComponent<T>
{
    public static final RecipeComponentFactory FACTORY = (registries, storage, reader) -> {
        reader.skipWhitespace();
        reader.expect('<');
        reader.skipWhitespace();
        ResourceLocation regId = ResourceLocation.read((StringReader)reader);
        reader.expect('>');
        ResourceKey key = ResourceKey.createRegistryKey((ResourceLocation)regId);
        return new RegistryComponent((Registry<?>)((Registry)registries.access().registry(key).orElseThrow()), RegistryType.ofKey(key), (Codec<?>)RegistryFixedCodec.create((ResourceKey)key));
    };

    @Override
    public TypeInfo typeInfo() {
        return this.regType == null || this.regType.type() == TypeInfo.STRING ? TypeInfo.STRING : TypeInfo.STRING.or(this.regType.type());
    }

    @Override
    public T wrap(Context cx, KubeRecipe recipe, Object from) {
        if (this.registry == BuiltInRegistries.ITEM) {
            if (from instanceof ItemStack) {
                ItemStack is = (ItemStack)from;
                return (T)is.getItem();
            }
            if (from instanceof Item) {
                return (T)from;
            }
            return (T)ItemStackJS.wrap(RegistryAccessContainer.of(cx), from).getItem();
        }
        if (this.registry == BuiltInRegistries.FLUID) {
            if (from instanceof FluidStack) {
                FluidStack fs = (FluidStack)from;
                return (T)fs.getFluid();
            }
            if (from instanceof Fluid) {
                return (T)from;
            }
            return (T)FluidWrapper.wrap(RegistryAccessContainer.of(cx), from).getFluid();
        }
        if (this.regType != null && this.regType.baseClass().isInstance(from)) {
            return (T)from;
        }
        return (T)this.registry.get(ID.mc(from));
    }

    @Override
    public boolean hasPriority(Context cx, KubeRecipe recipe, Object from) {
        JsonPrimitive json;
        return this.regType != null && this.regType.baseClass().isInstance(from) || from instanceof CharSequence && ID.mc(from.toString()) != null || from instanceof JsonPrimitive && (json = (JsonPrimitive)from).isString() && ID.mc(json.getAsString()) != null;
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, T value) {
        ResourceLocation id = this.registry.getKey(value);
        if (id != null) {
            builder.append(id);
        }
    }

    @Override
    public String toString() {
        return "registry_element<" + String.valueOf(this.registry.key().location()) + ">";
    }
}

