/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.latvian.mods.kubejs.error.EmptyRecipeComponentValueException;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.RecipesKubeEvent;
import dev.latvian.mods.kubejs.recipe.component.CharacterComponent;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.EitherRecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.ListRecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.MapRecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.PairRecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentBuilder;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentValue;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentWithCodec;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.match.Replaceable;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.util.TinyMap;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Nullable
public interface RecipeComponent<T> {
    public static RecipeComponentBuilder builder(List<RecipeComponentBuilder.Key> keys) {
        return new RecipeComponentBuilder(keys);
    }

    public static RecipeComponentBuilder builder(RecipeComponentBuilder.Key ... keys) {
        return new RecipeComponentBuilder(List.of(keys));
    }

    default public RecipeKey<T> key(String name, ComponentRole role) {
        return new RecipeKey(this, name, role);
    }

    default public RecipeKey<T> inputKey(String name) {
        return this.key(name, ComponentRole.INPUT);
    }

    default public RecipeKey<T> outputKey(String name) {
        return this.key(name, ComponentRole.OUTPUT);
    }

    default public RecipeKey<T> otherKey(String name) {
        return this.key(name, ComponentRole.OTHER);
    }

    public Codec<T> codec();

    public TypeInfo typeInfo();

    default public T wrap(Context cx, KubeRecipe recipe, Object from) {
        return (T)cx.jsToJava(from, this.typeInfo());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public void writeToJson(KubeRecipe recipe, RecipeComponentValue<T> cv, JsonObject json) {
        if (cv.key.names.size() >= 2) {
            for (String k : cv.key.names) {
                json.remove(k);
            }
        }
        DataResult dataResult = cv.key.codec.encodeStart(recipe.type.event.registries.json(), cv.value);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                JsonElement value;
                JsonElement jsonElement;
                DataResult.Success success = (DataResult.Success)dataResult2;
                try {
                    value = jsonElement = (JsonElement)success.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                {
                    JsonElement lifecycle = jsonElement = success.lifecycle();
                }
                json.add(cv.key.name, value);
                return;
            }
            case 1: 
        }
        DataResult.Error error = (DataResult.Error)dataResult2;
        ConsoleJS.SERVER.error("Failed to encode " + cv.key.name + " for recipe " + String.valueOf(recipe.id) + " from value" + String.valueOf(cv.value) + ": " + error.message(), recipe.sourceLine, null, RecipesKubeEvent.POST_SKIP_ERROR);
    }

    default public void readFromJson(KubeRecipe recipe, RecipeComponentValue<T> cv, JsonObject json) {
        JsonElement v = json.get(cv.key.name);
        if (v != null) {
            cv.value = recipe.type.event.registries.decodeJson(cv.key.codec, v);
        } else if (cv.key.names.size() >= 2) {
            for (String alt : cv.key.names) {
                v = json.get(alt);
                if (v == null) continue;
                cv.value = recipe.type.event.registries.decodeJson(cv.key.codec, v);
                return;
            }
        }
    }

    default public boolean hasPriority(Context cx, KubeRecipe recipe, Object from) {
        return false;
    }

    default public boolean matches(Context cx, KubeRecipe recipe, T value, ReplacementMatchInfo match) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    default public T replace(Context cx, KubeRecipe recipe, T original, ReplacementMatchInfo match, Object with) {
        T t;
        if (original instanceof Replaceable) {
            Replaceable r = (Replaceable)original;
            if (this.matches(cx, recipe, original, match)) {
                t = this.wrap(cx, recipe, r.replaceThisWith(cx, with));
                return t;
            }
        }
        t = original;
        return t;
    }

    default public void validate(T value) {
        if (this.isEmpty(value)) {
            throw new EmptyRecipeComponentValueException(this);
        }
    }

    default public boolean isEmpty(T value) {
        return false;
    }

    default public void buildUniqueId(UniqueIdBuilder builder, T value) {
        builder.append(value.toString());
    }

    default public RecipeComponent<List<T>> asList() {
        return ListRecipeComponent.create(this, false, false);
    }

    default public RecipeComponent<List<T>> asListOrSelf() {
        return ListRecipeComponent.create(this, true, false);
    }

    default public RecipeComponent<List<T>> asConditionalList() {
        return ListRecipeComponent.create(this, false, true);
    }

    default public RecipeComponent<List<T>> asConditionalListOrSelf() {
        return ListRecipeComponent.create(this, true, true);
    }

    default public RecipeComponent<T> orSelf() {
        return this;
    }

    default public <K> RecipeComponent<TinyMap<K, T>> asMap(RecipeComponent<K> key) {
        return new MapRecipeComponent(key, this, false);
    }

    default public RecipeComponent<TinyMap<Character, T>> asPatternKey() {
        return new MapRecipeComponent(CharacterComponent.CHARACTER, this, true);
    }

    default public <O> EitherRecipeComponent<T, O> or(RecipeComponent<O> other) {
        return new EitherRecipeComponent(this, other);
    }

    default public <O> PairRecipeComponent<T, O> and(RecipeComponent<O> other) {
        return new PairRecipeComponent(this, other);
    }

    default public RecipeComponent<T> withCodec(Codec<T> codec) {
        return new RecipeComponentWithCodec<T>(this, codec);
    }
}

