/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.fluid.FluidWrapper;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.match.FluidMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class FluidIngredientComponent
implements RecipeComponent<FluidIngredient> {
    public static final FluidIngredientComponent FLUID_INGREDIENT = new FluidIngredientComponent();

    @Override
    public Codec<FluidIngredient> codec() {
        return FluidIngredient.CODEC;
    }

    @Override
    public TypeInfo typeInfo() {
        return FluidWrapper.INGREDIENT_TYPE_INFO;
    }

    @Override
    public boolean hasPriority(Context cx, KubeRecipe recipe, Object from) {
        return from instanceof SizedFluidIngredient || from instanceof FluidIngredient || from instanceof FluidStack || from instanceof Fluid;
    }

    @Override
    public boolean matches(Context cx, KubeRecipe recipe, FluidIngredient value, ReplacementMatchInfo match) {
        FluidMatch m;
        ReplacementMatch replacementMatch = match.match();
        return replacementMatch instanceof FluidMatch && (m = (FluidMatch)replacementMatch).matches(cx, value, match.exact());
    }

    @Override
    public boolean isEmpty(FluidIngredient value) {
        return value.isEmpty();
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, FluidIngredient value) {
        if (!value.isEmpty()) {
            builder.append(value.getStacks()[0].getFluid().kjs$getIdLocation());
        }
    }

    public String toString() {
        return "fluid_ingredient";
    }
}

