/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentValue;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentValueFunction;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaFunction;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.SequencedCollection;

public class RecipeFunction
extends NativeJavaObject {
    public final KubeRecipe recipe;
    public final Map<String, BaseFunction> builderFunctions;

    private static boolean isValidIdentifier(char[] name) {
        if (name.length == 0 || !Character.isJavaIdentifierStart(name[0])) {
            return false;
        }
        for (int i = 1; i < name.length; ++i) {
            if (Character.isJavaIdentifierPart(name[i])) continue;
            return false;
        }
        return true;
    }

    public RecipeFunction(Context cx, Scriptable scope, TypeInfo staticType, KubeRecipe recipe) {
        super(scope, (Object)recipe, staticType, cx);
        this.recipe = recipe;
        this.builderFunctions = new HashMap<String, BaseFunction>();
        for (RecipeComponentValue<?> value : recipe.getRecipeComponentValues()) {
            SequencedCollection<String> names;
            SequencedCollection<String> sequencedCollection = names = value.key.functionNames == null ? value.key.names : value.key.functionNames;
            if (names.isEmpty()) continue;
            RecipeComponentValueFunction func = new RecipeComponentValueFunction(recipe, value);
            for (String name : names) {
                if (!RecipeFunction.isValidIdentifier(name.toCharArray())) continue;
                this.builderFunctions.put(name, func);
            }
        }
        for (Map.Entry entry : recipe.type.schemaType.schema.functions.entrySet()) {
            if (!RecipeFunction.isValidIdentifier(((String)entry.getKey()).toCharArray())) continue;
            this.builderFunctions.put((String)entry.getKey(), new RecipeSchemaFunction.JSFunction(recipe, (RecipeSchemaFunction)entry.getValue()));
        }
    }

    public Object get(Context cx, String name, Scriptable start) {
        BaseFunction r;
        Object s = super.get(cx, name, start);
        if (s == Scriptable.NOT_FOUND && (r = this.builderFunctions.get(name)) != null) {
            return r;
        }
        return s;
    }
}

