/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level;

import dev.latvian.mods.kubejs.bindings.BlockWrapper;
import dev.latvian.mods.kubejs.core.InventoryKJS;
import dev.latvian.mods.kubejs.level.ExplosionJS;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.util.SpecialEquality;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class BlockContainerJS
implements SpecialEquality {
    public final Level minecraftLevel;
    private final BlockPos pos;
    public transient BlockState cachedState;
    public transient BlockEntity cachedEntity;

    public BlockContainerJS(Level w, BlockPos p) {
        this.minecraftLevel = w;
        this.pos = p;
    }

    public BlockContainerJS(BlockEntity blockEntity) {
        this.minecraftLevel = blockEntity.getLevel();
        this.pos = blockEntity.getBlockPos();
        this.cachedEntity = blockEntity;
    }

    public void clearCache() {
        this.cachedState = null;
        this.cachedEntity = null;
    }

    public Level getLevel() {
        return this.minecraftLevel;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public ResourceLocation getDimension() {
        return this.minecraftLevel.dimension().location();
    }

    public int getX() {
        return this.getPos().getX();
    }

    public int getY() {
        return this.getPos().getY();
    }

    public int getZ() {
        return this.getPos().getZ();
    }

    public BlockContainerJS offset(Direction f, int d) {
        return new BlockContainerJS(this.minecraftLevel, this.getPos().relative(f, d));
    }

    public BlockContainerJS offset(Direction f) {
        return this.offset(f, 1);
    }

    public BlockContainerJS offset(int x, int y, int z) {
        return new BlockContainerJS(this.minecraftLevel, this.getPos().offset(x, y, z));
    }

    public BlockContainerJS getDown() {
        return this.offset(Direction.DOWN);
    }

    public BlockContainerJS getUp() {
        return this.offset(Direction.UP);
    }

    public BlockContainerJS getNorth() {
        return this.offset(Direction.NORTH);
    }

    public BlockContainerJS getSouth() {
        return this.offset(Direction.SOUTH);
    }

    public BlockContainerJS getWest() {
        return this.offset(Direction.WEST);
    }

    public BlockContainerJS getEast() {
        return this.offset(Direction.EAST);
    }

    public BlockState getBlockState() {
        if (this.cachedState == null) {
            this.cachedState = this.minecraftLevel.getBlockState(this.getPos());
        }
        return this.cachedState;
    }

    public void setBlockState(BlockState state, int flags) {
        this.minecraftLevel.setBlock(this.getPos(), state, flags);
        this.clearCache();
        this.cachedState = state;
    }

    public ResourceLocation getId() {
        return this.getBlockState().getBlock().kjs$getIdLocation();
    }

    public Collection<ResourceLocation> getTags() {
        return Tags.byBlockState(this.getBlockState()).map(TagKey::location).collect(Collectors.toSet());
    }

    public boolean hasTag(ResourceLocation tag) {
        return this.getBlockState().is(Tags.block(tag));
    }

    public void set(Block block, Map<?, ?> properties, int flags) {
        BlockState state = block.defaultBlockState();
        if (!properties.isEmpty() && state.getBlock() != Blocks.AIR) {
            state = BlockWrapper.withProperties(state, properties);
            HashMap<String, Property> pmap = new HashMap<String, Property>();
            for (Property property : state.getProperties()) {
                pmap.put(property.getName(), property);
            }
            for (Map.Entry entry : properties.entrySet()) {
                Property property = (Property)pmap.get(String.valueOf(entry.getKey()));
                if (property == null) continue;
                state = (BlockState)state.setValue(property, (Comparable)Cast.to(property.getValue(String.valueOf(entry.getValue())).orElseThrow()));
            }
        }
        this.setBlockState(state, flags);
    }

    public void set(Block block, Map<?, ?> properties) {
        this.set(block, properties, 3);
    }

    public void set(Block block) {
        this.set(block, Collections.emptyMap());
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        BlockState state = this.getBlockState();
        for (Property property : state.getProperties()) {
            map.put(property.getName(), property.getName(state.getValue(property)));
        }
        return map;
    }

    @Nullable
    public BlockEntity getEntity() {
        if (this.cachedEntity == null || this.cachedEntity.isRemoved()) {
            this.cachedEntity = this.minecraftLevel.getBlockEntity(this.pos);
        }
        return this.cachedEntity;
    }

    public String getEntityId() {
        BlockEntity entity = this.getEntity();
        return entity == null ? "minecraft:air" : BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)entity.getType()).toString();
    }

    @Nullable
    public CompoundTag getEntityData() {
        BlockEntity entity = this.getEntity();
        if (entity != null) {
            return entity.saveWithoutMetadata((HolderLookup.Provider)this.minecraftLevel.registryAccess());
        }
        return null;
    }

    public void setEntityData(@Nullable CompoundTag tag) {
        BlockEntity entity;
        if (tag != null && (entity = this.getEntity()) != null) {
            entity.loadWithComponents(tag, (HolderLookup.Provider)this.minecraftLevel.registryAccess());
        }
    }

    public void mergeEntityData(@Nullable CompoundTag tag) {
        CompoundTag t = this.getEntityData();
        if (t == null) {
            this.setEntityData(tag);
        } else if (tag != null && !tag.isEmpty()) {
            for (String s : tag.getAllKeys()) {
                t.put(s, tag.get(s));
            }
        }
        this.setEntityData(t);
    }

    public int getLight() {
        return this.minecraftLevel.getMaxLocalRawBrightness(this.pos);
    }

    public int getSkyLight() {
        return this.minecraftLevel.getBrightness(LightLayer.SKY, this.pos) - this.minecraftLevel.getSkyDarken();
    }

    public int getBlockLight() {
        return this.minecraftLevel.getBrightness(LightLayer.BLOCK, this.pos);
    }

    public boolean getCanSeeSky() {
        return this.minecraftLevel.canSeeSky(this.pos);
    }

    public boolean canSeeSkyFromBelowWater() {
        return this.minecraftLevel.canSeeSkyFromBelowWater(this.pos);
    }

    public String toString() {
        ResourceLocation id = this.getId();
        Map<String, String> properties = this.getProperties();
        if (properties.isEmpty()) {
            return id.toString();
        }
        StringBuilder builder = new StringBuilder(id.toString());
        builder.append('[');
        boolean first = true;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(entry.getValue());
        }
        builder.append(']');
        return builder.toString();
    }

    public ExplosionJS createExplosion() {
        return new ExplosionJS((LevelAccessor)this.minecraftLevel, (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5);
    }

    @Nullable
    public Entity createEntity(EntityType<?> type) {
        Entity entity = this.getLevel().kjs$createEntity(type);
        if (entity != null) {
            entity.kjs$setPosition(this);
        }
        return entity;
    }

    public void spawnLightning(boolean effectOnly, @Nullable ServerPlayer player) {
        if (this.minecraftLevel instanceof ServerLevel) {
            LightningBolt e = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.minecraftLevel);
            e.moveTo((double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5);
            e.setCause(player);
            e.setVisualOnly(effectOnly);
            this.minecraftLevel.addFreshEntity((Entity)e);
        }
    }

    public void spawnLightning(boolean effectOnly) {
        this.spawnLightning(effectOnly, null);
    }

    public void spawnLightning() {
        this.spawnLightning(false);
    }

    public void spawnFireworks(Fireworks fireworks, int lifetime) {
        this.minecraftLevel.kjs$spawnFireworks((double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5, fireworks, lifetime);
    }

    @Nullable
    public InventoryKJS getInventory() {
        return this.getInventory(Direction.UP);
    }

    @Nullable
    public InventoryKJS getInventory(Direction facing) {
        BlockEntity entity = this.getEntity();
        if (entity != null) {
            IItemHandler c = (IItemHandler)this.minecraftLevel.getCapability(Capabilities.ItemHandler.BLOCK, this.getPos(), this.getBlockState(), this.getEntity(), (Object)facing);
            if (c instanceof InventoryKJS) {
                InventoryKJS inv = (InventoryKJS)c;
                return inv;
            }
            if (entity instanceof InventoryKJS) {
                InventoryKJS inv = (InventoryKJS)entity;
                return inv;
            }
        }
        return null;
    }

    public ItemStack getItem() {
        BlockState state = this.getBlockState();
        return state.getBlock().getCloneItemStack((LevelReader)this.minecraftLevel, this.pos, state);
    }

    public List<ItemStack> getDrops() {
        return this.getDrops(null, ItemStack.EMPTY);
    }

    public List<ItemStack> getDrops(@Nullable Entity entity, ItemStack heldItem) {
        Level level = this.minecraftLevel;
        if (level instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            return Block.getDrops((BlockState)this.getBlockState(), (ServerLevel)s, (BlockPos)this.pos, (BlockEntity)this.getEntity(), (Entity)entity, (ItemStack)heldItem);
        }
        return null;
    }

    public void popItem(ItemStack item) {
        Block.popResource((Level)this.minecraftLevel, (BlockPos)this.pos, (ItemStack)item);
    }

    public void popItemFromFace(ItemStack item, Direction dir) {
        Block.popResourceFromFace((Level)this.minecraftLevel, (BlockPos)this.pos, (Direction)dir, (ItemStack)item);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CharSequence || obj instanceof ResourceLocation) {
            return this.getId().equals((Object)obj.toString());
        }
        return super.equals(obj);
    }

    private static boolean isReal(Player p) {
        return !(p instanceof FakePlayer);
    }

    public EntityArrayList getPlayersInRadius(double radius) {
        return new EntityArrayList(this.minecraftLevel, this.minecraftLevel.getEntitiesOfClass(Player.class, new AABB((double)this.pos.getX() - radius, (double)this.pos.getY() - radius, (double)this.pos.getZ() - radius, (double)this.pos.getX() + 1.0 + radius, (double)this.pos.getY() + 1.0 + radius, (double)this.pos.getZ() + 1.0 + radius), BlockContainerJS::isReal));
    }

    public EntityArrayList getPlayersInRadius() {
        return this.getPlayersInRadius(8.0);
    }

    public ResourceLocation getBiomeId() {
        ResourceKey k = this.minecraftLevel.getBiome(this.pos).getKey();
        return k == null ? Biomes.PLAINS.location() : k.location();
    }

    public boolean specialEquals(Context cx, Object o, boolean shallow) {
        if (o instanceof CharSequence || o instanceof ResourceLocation) {
            return this.getId().equals((Object)o.toString());
        }
        return this.equals(o);
    }

    public Map<String, Object> getTypeData() {
        return this.getBlockState().getBlock().kjs$getTypeData();
    }
}

