/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.custom;

import dev.latvian.mods.kubejs.generator.KubeAssetGenerator;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.rhino.util.ReturnsSelf;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;

@ReturnsSelf
public class ShearsItemBuilder
extends ItemBuilder {
    public static final ResourceLocation[] SHEAR_TAGS = new ResourceLocation[]{Tags.Items.TOOLS_SHEAR.location()};
    public transient float speedBaseline;

    public static boolean isCustomShears(ItemStack stack) {
        return stack.getItem() instanceof ShearsItemKJS;
    }

    public ShearsItemBuilder(ResourceLocation i) {
        super(i);
        this.speedBaseline(5.0f);
        this.parentModel(KubeAssetGenerator.HANDHELD_ITEM_MODEL);
        this.unstackable();
        this.tag(SHEAR_TAGS);
        this.tool = ShearsItem.createToolProperties();
    }

    public ShearsItemBuilder speedBaseline(float f) {
        this.speedBaseline = f;
        return this;
    }

    @Override
    public Item createObject() {
        ShearsItemKJS item = new ShearsItemKJS(this);
        DispenserBlock.registerBehavior((ItemLike)item, (DispenseItemBehavior)new ShearsDispenseItemBehavior());
        return item;
    }

    public static class ShearsItemKJS
    extends ShearsItem {
        public final ShearsItemBuilder builder;

        public ShearsItemKJS(ShearsItemBuilder builder) {
            super(builder.createItemProperties());
            this.builder = builder;
        }

        public float getDestroySpeed(ItemStack itemStack, BlockState blockState) {
            if (blockState.is(BlockTags.LEAVES)) {
                return 15.0f;
            }
            if (blockState.is(Blocks.COBWEB)) {
                return this.builder.speedBaseline * 3.0f;
            }
            if (blockState.is(Blocks.VINE) || blockState.is(Blocks.GLOW_LICHEN)) {
                return this.builder.speedBaseline / 2.5f;
            }
            if (blockState.is(BlockTags.WOOL)) {
                return this.builder.speedBaseline;
            }
            return super.getDestroySpeed(itemStack, blockState);
        }
    }
}

