/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.integration.rei;

import dev.architectury.event.EventResult;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import dev.latvian.mods.kubejs.integration.rei.DataComponentComparator;
import dev.latvian.mods.kubejs.integration.rei.REIAddEntriesKubeEvent;
import dev.latvian.mods.kubejs.integration.rei.REIAddInformationKubeEvent;
import dev.latvian.mods.kubejs.integration.rei.REIGroupEntriesKubeEvent;
import dev.latvian.mods.kubejs.integration.rei.REIIntegration;
import dev.latvian.mods.kubejs.integration.rei.REIRegisterFluidSubtypesKubeEvent;
import dev.latvian.mods.kubejs.integration.rei.REIRegisterItemSubtypesKubeEvent;
import dev.latvian.mods.kubejs.integration.rei.REIRemoveCategoriesKubeEvent;
import dev.latvian.mods.kubejs.integration.rei.REIRemoveEntriesCompletelyKubeEvent;
import dev.latvian.mods.kubejs.integration.rei.REIRemoveEntriesKubeEvent;
import dev.latvian.mods.kubejs.integration.rei.REIRemoveRecipeKubeEvent;
import dev.latvian.mods.kubejs.recipe.viewer.RecipeViewerEntryType;
import dev.latvian.mods.kubejs.recipe.viewer.RecipeViewerEvents;
import dev.latvian.mods.kubejs.recipe.viewer.server.CategoryData;
import dev.latvian.mods.kubejs.recipe.viewer.server.FluidData;
import dev.latvian.mods.kubejs.recipe.viewer.server.ItemData;
import dev.latvian.mods.kubejs.recipe.viewer.server.RecipeViewerData;
import dev.latvian.mods.kubejs.recipe.viewer.server.RemoteRecipeViewerDataUpdatedEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.shedaniel.rei.api.client.entry.filtering.base.BasicFilteringRule;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.EntryComparator;
import me.shedaniel.rei.api.common.entry.comparison.FluidComparatorRegistry;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import me.shedaniel.rei.plugin.client.BuiltinClientPlugin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;

@REIPluginClient
public class KubeJSREIPlugin
implements REIClientPlugin {
    private final Set<CategoryIdentifier<?>> categoriesRemoved = new HashSet();
    private final Map<CategoryIdentifier<?>, Collection<ResourceLocation>> recipesRemoved = new HashMap();
    private RecipeViewerData remote = null;

    public KubeJSREIPlugin() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public double getPriority() {
        return 1.0E7;
    }

    @SubscribeEvent
    public void loadRemote(RemoteRecipeViewerDataUpdatedEvent event) {
        this.remote = event.data;
    }

    public void registerEntries(EntryRegistry registry) {
        for (RecipeViewerEntryType recipeViewerEntryType : RecipeViewerEntryType.ALL_TYPES.get()) {
            EntryType<?> entryType = REIIntegration.typeOf(recipeViewerEntryType);
            if (entryType == null || !RecipeViewerEvents.ADD_ENTRIES.hasListeners(recipeViewerEntryType)) continue;
            RecipeViewerEvents.ADD_ENTRIES.post(ScriptType.CLIENT, recipeViewerEntryType, new REIAddEntriesKubeEvent(recipeViewerEntryType, entryType, registry));
        }
        if (this.remote != null) {
            for (ItemStack itemStack : this.remote.itemData().addedEntries()) {
                registry.addEntries(new EntryStack[]{EntryStacks.of((ItemStack)itemStack)});
            }
            for (net.neoforged.neoforge.fluids.FluidStack fluidStack : this.remote.fluidData().addedEntries()) {
                registry.addEntries(new EntryStack[]{EntryStacks.of((FluidStack)FluidStackHooksForge.fromForge((net.neoforged.neoforge.fluids.FluidStack)fluidStack))});
            }
        }
    }

    public void registerBasicEntryFiltering(BasicFilteringRule<?> rule) {
        for (RecipeViewerEntryType type : RecipeViewerEntryType.ALL_TYPES.get()) {
            EntryType<?> entryType = REIIntegration.typeOf(type);
            if (entryType != null && RecipeViewerEvents.REMOVE_ENTRIES.hasListeners(type)) {
                EntryRegistry entryRegistry = EntryRegistry.getInstance();
                List<EntryStack<?>> allItems = entryRegistry.getEntryStacks().filter(e -> e.getType() == entryType).toList();
                RecipeViewerEvents.REMOVE_ENTRIES.post(ScriptType.CLIENT, type, new REIRemoveEntriesKubeEvent(type, entryRegistry, allItems));
            }
            if (entryType == null || !RecipeViewerEvents.REMOVE_ENTRIES_COMPLETELY.hasListeners(type)) continue;
            EntryRegistry entryRegistry = EntryRegistry.getInstance();
            List<EntryStack<?>> allFluids = entryRegistry.getEntryStacks().filter(e -> e.getType() == entryType).toList();
            RecipeViewerEvents.REMOVE_ENTRIES_COMPLETELY.post(ScriptType.CLIENT, type, new REIRemoveEntriesCompletelyKubeEvent(type, allFluids, rule));
        }
        if (this.remote != null) {
            EntryRegistry registry = EntryRegistry.getInstance();
            if (!this.remote.itemData().removedEntries().isEmpty() || this.remote.itemData().completelyRemovedEntries().isEmpty()) {
                List<EntryStack> allItems = registry.getEntryStacks().filter(e -> e.getType() == VanillaEntryTypes.ITEM).toList();
                for (Ingredient ingredient : this.remote.itemData().removedEntries()) {
                    for (EntryStack entry : allItems) {
                        if (!ingredient.test((ItemStack)entry.getValue())) continue;
                        registry.removeEntry(entry);
                    }
                }
                for (Ingredient ingredient : this.remote.itemData().completelyRemovedEntries()) {
                    rule.hide(allItems.stream().filter(e -> filter.test((ItemStack)e.getValue())).toList());
                }
            }
            if (!this.remote.fluidData().removedEntries().isEmpty() || this.remote.fluidData().completelyRemovedEntries().isEmpty()) {
                List<EntryStack> allFluids = registry.getEntryStacks().filter(e -> e.getType() == VanillaEntryTypes.FLUID).toList();
                for (FluidIngredient fluidIngredient : this.remote.fluidData().removedEntries()) {
                    for (EntryStack entry : allFluids) {
                        if (!fluidIngredient.test(FluidStackHooksForge.toForge((FluidStack)((FluidStack)entry.getValue())))) continue;
                        registry.removeEntry(entry);
                    }
                }
                for (FluidIngredient fluidIngredient : this.remote.fluidData().completelyRemovedEntries()) {
                    rule.hide(allFluids.stream().filter(e -> fluidIngredient.test(FluidStackHooksForge.toForge((FluidStack)((FluidStack)e.getValue())))).toList());
                }
            }
        }
    }

    public void registerDisplays(DisplayRegistry registry) {
        for (RecipeViewerEntryType recipeViewerEntryType : RecipeViewerEntryType.ALL_TYPES.get()) {
            if (!RecipeViewerEvents.ADD_INFORMATION.hasListeners(recipeViewerEntryType)) continue;
            RecipeViewerEvents.ADD_INFORMATION.post(ScriptType.CLIENT, recipeViewerEntryType, new REIAddInformationKubeEvent(recipeViewerEntryType));
        }
        if (this.remote != null) {
            for (ItemData.Info info : this.remote.itemData().info()) {
                if (info.filter().isEmpty() || info.info().isEmpty()) continue;
                BuiltinClientPlugin.getInstance().registerInformation(EntryIngredients.ofIngredient((Ingredient)info.filter()), info.info().getFirst(), components -> {
                    for (int i = 1; i < info.info().size(); ++i) {
                        components.add(info.info().get(i));
                    }
                    return components;
                });
            }
            for (FluidData.Info info : this.remote.fluidData().info()) {
                if (info.filter().isEmpty() || info.info().isEmpty()) continue;
                BuiltinClientPlugin.getInstance().registerInformation(REIIntegration.fluidIngredient(info.filter()), info.info().getFirst(), components -> {
                    for (int i = 1; i < info.info().size(); ++i) {
                        components.add(info.info().get(i));
                    }
                    return components;
                });
            }
        }
        registry.registerVisibilityPredicate((cat, display) -> {
            Optional id = display.getDisplayLocation();
            if (id.isPresent() && ((Collection)this.recipesRemoved.getOrDefault(cat.getCategoryIdentifier(), List.of())).contains(id.get())) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.registerVisibilityPredicate(category -> this.categoriesRemoved.contains(category.getCategoryIdentifier()) ? EventResult.interruptFalse() : EventResult.pass());
    }

    public void postStage(PluginManager<REIClientPlugin> manager, ReloadStage stage) {
        if (stage == ReloadStage.END) {
            this.categoriesRemoved.clear();
            this.recipesRemoved.clear();
            if (RecipeViewerEvents.REMOVE_CATEGORIES.hasListeners()) {
                RecipeViewerEvents.REMOVE_CATEGORIES.post(ScriptType.CLIENT, new REIRemoveCategoriesKubeEvent(this.categoriesRemoved));
            }
            if (RecipeViewerEvents.REMOVE_RECIPES.hasListeners()) {
                RecipeViewerEvents.REMOVE_RECIPES.post(ScriptType.CLIENT, new REIRemoveRecipeKubeEvent(this.recipesRemoved));
            }
            if (this.remote != null) {
                this.categoriesRemoved.addAll(this.remote.removedCategories().stream().map(CategoryIdentifier::of).toList());
                for (CategoryData entry : this.remote.categoryData()) {
                    this.recipesRemoved.computeIfAbsent(CategoryIdentifier.of((ResourceLocation)entry.category()), k -> new HashSet()).addAll(entry.removedRecipes());
                }
            }
        }
    }

    public void registerCollapsibleEntries(CollapsibleEntryRegistry registry) {
        for (RecipeViewerEntryType recipeViewerEntryType : RecipeViewerEntryType.ALL_TYPES.get()) {
            EntryType<?> entryType = REIIntegration.typeOf(recipeViewerEntryType);
            if (entryType == null || !RecipeViewerEvents.GROUP_ENTRIES.hasListeners(recipeViewerEntryType)) continue;
            RecipeViewerEvents.GROUP_ENTRIES.post(ScriptType.CLIENT, recipeViewerEntryType, new REIGroupEntriesKubeEvent(recipeViewerEntryType, entryType, registry));
        }
        if (this.remote != null) {
            for (ItemData.Group group : this.remote.itemData().groupedEntries()) {
                registry.group(group.groupId(), group.description(), e -> e.getType() == VanillaEntryTypes.ITEM && group.filter().test((ItemStack)e.getValue()));
            }
            for (FluidData.Group group : this.remote.fluidData().groupedEntries()) {
                registry.group(group.groupId(), group.description(), e -> e.getType() == VanillaEntryTypes.FLUID && group.filter().test(FluidStackHooksForge.toForge((FluidStack)((FluidStack)e.getValue()))));
            }
        }
    }

    public void registerItemComparators(ItemComparatorRegistry registry) {
        if (RecipeViewerEvents.REGISTER_SUBTYPES.hasListeners(RecipeViewerEntryType.ITEM)) {
            RecipeViewerEvents.REGISTER_SUBTYPES.post(ScriptType.CLIENT, RecipeViewerEntryType.ITEM, new REIRegisterItemSubtypesKubeEvent(registry));
        }
        if (this.remote != null) {
            for (ItemData.DataComponentSubtypes subtypes : this.remote.itemData().dataComponentSubtypes()) {
                Object[] items = subtypes.filter().kjs$getItemTypes().toArray(new Item[0]);
                if (subtypes.components().isEmpty()) {
                    registry.registerComponents((Item[])items);
                    continue;
                }
                registry.register((EntryComparator)DataComponentComparator.of(subtypes.components()), items);
            }
        }
    }

    public void registerFluidComparators(FluidComparatorRegistry registry) {
        if (RecipeViewerEvents.REGISTER_SUBTYPES.hasListeners(RecipeViewerEntryType.FLUID)) {
            RecipeViewerEvents.REGISTER_SUBTYPES.post(ScriptType.CLIENT, RecipeViewerEntryType.FLUID, new REIRegisterFluidSubtypesKubeEvent(registry));
        }
        if (this.remote != null) {
            for (FluidData.DataComponentSubtypes subtypes : this.remote.fluidData().dataComponentSubtypes()) {
                Object[] fluids = (Fluid[])Arrays.stream(subtypes.filter().getStacks()).map(net.neoforged.neoforge.fluids.FluidStack::getFluid).toArray(Fluid[]::new);
                registry.register((EntryComparator)DataComponentComparator.of(subtypes.components()), fluids);
            }
        }
    }
}

