/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.fluid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.fluid.KubeJSFluidIngredients;
import io.netty.buffer.ByteBuf;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.FluidIngredientType;

public class NamespaceFluidIngredient
extends FluidIngredient {
    public static final MapCodec<NamespaceFluidIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("namespace").forGetter(i -> i.namespace)).apply((Applicative)instance, NamespaceFluidIngredient::new));
    public static final StreamCodec<ByteBuf, NamespaceFluidIngredient> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(NamespaceFluidIngredient::new, i -> i.namespace);
    public final String namespace;

    public NamespaceFluidIngredient(String namespace) {
        this.namespace = namespace;
    }

    public FluidIngredientType<?> getType() {
        return KubeJSFluidIngredients.NAMESPACE.get();
    }

    public boolean test(FluidStack fs) {
        return fs.getFluid().kjs$getMod().equals(this.namespace);
    }

    protected Stream<FluidStack> generateStacks() {
        return BuiltInRegistries.FLUID.stream().filter(fluid -> fluid.kjs$getMod().equals(this.namespace)).map(fluid -> new FluidStack(fluid, 1000));
    }

    public boolean isSimple() {
        return true;
    }

    public int hashCode() {
        return this.namespace.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (o == this) return true;
        if (!(o instanceof NamespaceFluidIngredient)) return false;
        NamespaceFluidIngredient r = (NamespaceFluidIngredient)((Object)o);
        if (!this.namespace.equals(r.namespace)) return false;
        return true;
    }
}

