/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class SoundsGenerator {
    private final Map<String, SoundGen> sounds = new HashMap<String, SoundGen>();

    public void addSound(String path, Consumer<SoundGen> consumer, boolean overlayExisting) {
        if (overlayExisting && this.sounds.containsKey(path)) {
            consumer.accept(this.sounds.get(path));
        } else {
            this.sounds.put(path, (SoundGen)Util.make((Object)new SoundGen(), consumer));
        }
    }

    public void addSound(String path, Consumer<SoundGen> consumer) {
        this.addSound(path, consumer, false);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        this.sounds.forEach((path, gen) -> json.add(path, (JsonElement)gen.toJson()));
        return json;
    }

    public static class SoundGen {
        private boolean replace = false;
        @Nullable
        private String subtitle;
        private final List<SoundInstance> instances = new ArrayList<SoundInstance>();

        public SoundGen replace(boolean b) {
            this.replace = b;
            return this;
        }

        public SoundGen replace() {
            return this.replace(true);
        }

        public SoundGen subtitle(@Nullable String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public SoundGen sound(String file) {
            this.instances.add(new SoundInstance(file));
            return this;
        }

        public SoundGen sounds(String ... sounds) {
            this.instances.addAll(Stream.of(sounds).map(SoundInstance::new).toList());
            return this;
        }

        public SoundGen sound(String file, Consumer<SoundInstance> consumer) {
            this.instances.add((SoundInstance)Util.make((Object)new SoundInstance(file), consumer));
            return this;
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            if (this.replace) {
                json.addProperty("replace", Boolean.valueOf(true));
            }
            if (this.subtitle != null) {
                json.addProperty("subtitle", this.subtitle);
            }
            if (!this.instances.isEmpty()) {
                JsonArray array = new JsonArray(this.instances.size());
                this.instances.forEach(inst -> array.add(inst.toJson()));
                json.add("sounds", (JsonElement)array);
            }
            return json;
        }
    }

    public static class SoundInstance {
        private final String fileLocation;
        private boolean complex = false;
        private float volume = 1.0f;
        private float pitch = 1.0f;
        private int weight = 1;
        private boolean stream = false;
        private int attenuationDistance = 16;
        private boolean preload = false;
        private boolean isEventReference = false;

        public SoundInstance(String fileLocation) {
            this.fileLocation = fileLocation;
        }

        private SoundInstance complex() {
            this.complex = true;
            return this;
        }

        public SoundInstance volume(float f) {
            this.volume = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
            return this.complex();
        }

        public SoundInstance pitch(float f) {
            this.pitch = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
            return this.complex();
        }

        public SoundInstance weight(int i) {
            this.weight = i;
            return this.complex();
        }

        public SoundInstance stream(boolean b) {
            this.stream = b;
            return this.complex();
        }

        public SoundInstance stream() {
            return this.stream(true);
        }

        public SoundInstance attenuationDistance(int i) {
            this.attenuationDistance = i;
            return this.complex();
        }

        public SoundInstance preload(boolean b) {
            this.preload = b;
            return this.complex();
        }

        public SoundInstance preload() {
            return this.preload(true);
        }

        public SoundInstance asReferenceToEvent() {
            this.isEventReference = true;
            return this.complex();
        }

        public JsonElement toJson() {
            if (!this.complex) {
                return new JsonPrimitive(this.fileLocation);
            }
            JsonObject json = new JsonObject();
            json.addProperty("name", this.fileLocation);
            json.addProperty("volume", (Number)Float.valueOf(this.volume));
            json.addProperty("pitch", (Number)Float.valueOf(this.pitch));
            json.addProperty("weight", (Number)this.weight);
            json.addProperty("stream", Boolean.valueOf(this.stream));
            json.addProperty("attenuation_distance", (Number)this.attenuationDistance);
            json.addProperty("preload", Boolean.valueOf(this.preload));
            if (this.isEventReference) {
                json.addProperty("type", "event");
            }
            return json;
        }
    }
}

