/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.datagen;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import dev.xylonity.knightquest.registry.KnightQuestItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class KQAddItemModifier
extends LootModifier {
    public static final Supplier<MapCodec<KQAddItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> KQAddItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(KQAddItemModifier::getItem)).and((App)Codec.FLOAT.fieldOf("chance").forGetter(KQAddItemModifier::getChance)).apply((Applicative)inst, KQAddItemModifier::new)));
    private final Item item;
    private float chance;

    public KQAddItemModifier(LootItemCondition[] conditionsIn, Item item, float chance) {
        super(conditionsIn);
        this.item = item;
        this.chance = chance;
    }

    public Item getItem() {
        return this.item;
    }

    public float getChance() {
        return this.chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        if (this.item == KnightQuestItems.RATMAN_EYE.get()) {
            Random random = new Random();
            if (random.nextFloat() <= KQConfigValues.DROP_CHANCE_RATMAN_EYE.get().floatValue()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
        }
        if (this.item == KnightQuestItems.LIZZY_SCALE.get()) {
            Random random = new Random();
            if (random.nextFloat() <= KQConfigValues.DROP_CHANCE_LIZZY_SCALE.get().floatValue()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

