/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.entities;

import dev.xylonity.knightquest.KnightQuestCommon;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import dev.xylonity.knightquest.registry.KnightQuestItems;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FallenKnightEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public FallenKnightEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    public Iterable<ItemStack> getArmorSlots() {
        return Arrays.asList(this.getItemBySlot(EquipmentSlot.HEAD), this.getItemBySlot(EquipmentSlot.CHEST), this.getItemBySlot(EquipmentSlot.LEGS), this.getItemBySlot(EquipmentSlot.FEET));
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 35.0).add(Attributes.ATTACK_DAMAGE, 0.5).add(Attributes.ATTACK_SPEED, 2.0).add(Attributes.MOVEMENT_SPEED, 0.5);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, true));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "attackcontroller", 2, this::attackPredicate));
    }

    private PlayState attackPredicate(AnimationState<?> event) {
        if (this.swinging && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(RawAnimation.begin().then("animation.model.attack", Animation.LoopType.PLAY_ONCE));
            this.swinging = false;
        }
        return PlayState.CONTINUE;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pSpawnType, @Nullable SpawnGroupData pSpawnGroupData) {
        Item[] weapon = new Item[]{KnightQuestCommon.COMMON_PLATFORM.getPaladinSword().get()};
        int indexWeapons = this.random.nextInt(weapon.length);
        this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.SHIELD));
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)weapon[indexWeapons]));
        Item[] helmets = new Item[]{KnightQuestItems.VETERAN_HELMET.get(), KnightQuestItems.APPLE_HELMET.get(), KnightQuestItems.HORN_HELMET.get(), KnightQuestItems.ZOMBIE_HELMET2.get()};
        Item[] chestplates = new Item[]{KnightQuestItems.VETERAN_CHESTPLATE.get(), KnightQuestItems.APPLE_CHESTPLATE.get(), KnightQuestItems.HORN_CHESTPLATE.get(), KnightQuestItems.ZOMBIE_CHESTPLATE.get()};
        Item[] leggings = new Item[]{KnightQuestItems.VETERAN_LEGGINGS.get(), KnightQuestItems.APPLE_LEGGINGS.get(), KnightQuestItems.HORN_LEGGINGS.get(), KnightQuestItems.ZOMBIE_LEGGINGS.get()};
        Item[] boots = new Item[]{KnightQuestItems.VETERAN_BOOTS.get(), KnightQuestItems.APPLE_BOOTS.get(), KnightQuestItems.HORN_BOOTS.get(), KnightQuestItems.ZOMBIE_BOOTS.get()};
        int index = this.random.nextInt(helmets.length);
        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)helmets[index]));
        this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)chestplates[index]));
        this.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)leggings[index]));
        this.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)boots[index]));
        AttributeInstance maxHealth = this.getAttribute(Attributes.MAX_HEALTH);
        if (maxHealth != null) {
            maxHealth.setBaseValue(KQConfigValues.FALLENKNIGHT_MAX_HEALTH.get().doubleValue());
            this.setHealth(KQConfigValues.FALLENKNIGHT_MAX_HEALTH.get().floatValue());
        }
        return super.finalizeSpawn(pLevel, pDifficulty, pSpawnType, pSpawnGroupData);
    }

    private PlayState predicate(AnimationState<?> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("animation.model.walk", Animation.LoopType.LOOP));
        } else {
            event.getController().setAnimation(RawAnimation.begin().then("animation.model.idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            CompoundTag stackNbt = tag.getCompound(slot.getName());
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)stackNbt);
            if (stack.isEmpty()) continue;
            this.setItemSlot(slot, stack);
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || (stack = this.getItemBySlot(slot)).isEmpty()) continue;
            CompoundTag stackNbt = new CompoundTag();
            stack.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)stackNbt);
            tag.put(slot.getName(), (Tag)stackNbt);
        }
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_DEATH;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return SoundEvents.ZOMBIE_HURT;
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.playSound(SoundEvents.ZOMBIE_STEP, 0.15f, 1.0f);
    }
}

