/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.boss;

import dev.xylonity.knightquest.common.entity.boss.AbstractNethermanProjectile;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NethermanProjectileChargeEntity
extends AbstractNethermanProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int explosionTimer;
    private boolean shouldGoDown;

    public NethermanProjectileChargeEntity(EntityType<? extends AbstractNethermanProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setNoGravity(true);
        this.explosionTimer = this.random.nextInt(100) + 20;
        if (!this.level().isClientSide) {
            this.shouldGoDown = this.random.nextBoolean();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            --this.explosionTimer;
            if (this.explosionTimer <= 0) {
                this.explode();
            }
        }
        if (this.shouldGoDown && !this.level().isClientSide) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.05, 0.0));
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult pResult) {
        super.onHitBlock(pResult);
        if (!this.level().isClientSide) {
            this.explode();
        }
    }

    private void explode() {
        this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), KQConfigValues.NETHERMAN_PROJECTILE_EXPLOSION_RADIUS.get().floatValue(), Level.ExplosionInteraction.MOB);
        this.discard();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "rotateController", 0, this::rotatePredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "coreController", 0, this::corePredicate));
    }

    private PlayState corePredicate(AnimationState<?> event) {
        if (this.tickCount < 10) {
            event.getController().setAnimation(RawAnimation.begin().then("summon", Animation.LoopType.PLAY_ONCE));
        } else if (this.explosionTimer < 11) {
            event.getController().setAnimation(RawAnimation.begin().then("die", Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState rotatePredicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().then("rotate", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

