/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.entity.boss;

import dev.xylonity.knightquest.common.ai.navigator.GroundNavigator;
import dev.xylonity.knightquest.common.entity.boss.ai.NethermanAttackGoal;
import dev.xylonity.knightquest.common.entity.boss.ai.NethermanClonesGoal;
import dev.xylonity.knightquest.common.entity.boss.ai.NethermanDarknessGoal;
import dev.xylonity.knightquest.common.entity.boss.ai.NethermanFlameGoal;
import dev.xylonity.knightquest.common.entity.boss.ai.NethermanIceGoal;
import dev.xylonity.knightquest.common.entity.boss.ai.NethermanLavaTeleportGoal;
import dev.xylonity.knightquest.common.entity.boss.ai.NethermanNearestAttackableTargetGoal;
import dev.xylonity.knightquest.common.entity.boss.ai.NethermanProjectileChargesGoal;
import dev.xylonity.knightquest.common.entity.boss.ai.NethermanTeleport2PlayerGoal;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import dev.xylonity.knightquest.registry.KnightQuestItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NethermanEntity
extends Monster
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    private final Map<BlockPos, BlockState> changedBlocks = new HashMap<BlockPos, BlockState>();
    private final RawAnimation DEATH = RawAnimation.begin().thenPlay("death");
    private final RawAnimation SUMMONANIM = RawAnimation.begin().thenPlay("summon");
    private final RawAnimation WALKANIM = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLEANIM = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation SPECIALATTACKANIM = RawAnimation.begin().thenPlay("attack_special");
    private final RawAnimation SPECIALATTACK2ANIM = RawAnimation.begin().thenPlay("attack_special2");
    private final RawAnimation SPECIALATTACK3ANIM = RawAnimation.begin().thenPlay("attack_special3");
    private final RawAnimation PHASE_SWITCH_2 = RawAnimation.begin().thenPlay("phase2");
    private final RawAnimation PHASE_SWITCH_3 = RawAnimation.begin().thenPlay("phase3");
    private static final EntityDataAccessor<Boolean> SUMMON = SynchedEntityData.defineId(NethermanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> NOMOVEMENT = SynchedEntityData.defineId(NethermanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> INVULNERABLE = SynchedEntityData.defineId(NethermanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_DOING_FLAME_ATTACK = SynchedEntityData.defineId(NethermanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_DOING_SPECIAL_ATTACK2 = SynchedEntityData.defineId(NethermanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_DOING_SPECIAL_ATTACK3 = SynchedEntityData.defineId(NethermanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SHOULD_SEARCH_TARGET = SynchedEntityData.defineId(NethermanEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.defineId(NethermanEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> REVERT_FLAME_ATTACK = SynchedEntityData.defineId(NethermanEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> REVERT_SPECIAL_ATTACK2 = SynchedEntityData.defineId(NethermanEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> REVERT_SPECIAL_ATTACK3 = SynchedEntityData.defineId(NethermanEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> COUNTER_SWITCH_PHASE_2 = SynchedEntityData.defineId(NethermanEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> COUNTER_SWITCH_PHASE_3 = SynchedEntityData.defineId(NethermanEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean hasBeenSwitchedToPhase2 = false;
    private boolean hasBeenSwitchedToPhase3 = false;
    private boolean initAttributes = false;

    public NethermanEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 450.0).add(Attributes.ATTACK_DAMAGE, 16.0).add(Attributes.ATTACK_SPEED, (double)1.2f).add(Attributes.MOVEMENT_SPEED, (double)0.8f).add(Attributes.FOLLOW_RANGE, 75.0).add(Attributes.KNOCKBACK_RESISTANCE, 5.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new NethermanAttackGoal(this, 0.5, true));
        this.goalSelector.addGoal(4, (Goal)new NethermanTeleport2PlayerGoal(this));
        this.goalSelector.addGoal(2, (Goal)new NethermanLavaTeleportGoal(this));
        this.goalSelector.addGoal(3, (Goal)new NethermanFlameGoal(this));
        this.goalSelector.addGoal(2, (Goal)new NethermanClonesGoal(this));
        this.goalSelector.addGoal(3, (Goal)new NethermanIceGoal(this));
        this.goalSelector.addGoal(2, (Goal)new NethermanProjectileChargesGoal(this));
        this.goalSelector.addGoal(3, (Goal)new NethermanDarknessGoal(this));
        this.targetSelector.addGoal(1, new NethermanNearestAttackableTargetGoal<Player>((Mob)this, Player.class, true));
    }

    public boolean getInvulnerability() {
        return (Boolean)this.entityData.get(INVULNERABLE);
    }

    public void setInvulnerability(boolean invulnerability) {
        this.entityData.set(INVULNERABLE, (Object)invulnerability);
    }

    public int getPhase() {
        return (Integer)this.entityData.get(PHASE);
    }

    public void setPhase(int phase) {
        this.entityData.set(PHASE, (Object)phase);
    }

    public boolean getIsSummoning() {
        return (Boolean)this.entityData.get(SUMMON);
    }

    public void setIsSummoning(boolean summon) {
        this.entityData.set(SUMMON, (Object)summon);
    }

    public boolean getNoMovement() {
        return (Boolean)this.entityData.get(NOMOVEMENT);
    }

    public void setNoMovement(boolean noMovement) {
        this.entityData.set(NOMOVEMENT, (Object)noMovement);
    }

    public boolean getShouldSearchTarget() {
        return (Boolean)this.entityData.get(SHOULD_SEARCH_TARGET);
    }

    public void setShouldSearchTarget(boolean shouldSearchTarget) {
        this.entityData.set(SHOULD_SEARCH_TARGET, (Object)shouldSearchTarget);
    }

    public boolean getIsDoingFlameAttack() {
        return (Boolean)this.entityData.get(IS_DOING_FLAME_ATTACK);
    }

    public void setIsDoingFlameAttack(boolean isDoingFlameAttack) {
        this.entityData.set(IS_DOING_FLAME_ATTACK, (Object)isDoingFlameAttack);
    }

    public int getRevertFlameAttack() {
        return (Integer)this.entityData.get(REVERT_FLAME_ATTACK);
    }

    public void setRevertFlameAttack(int revertFlameAttack) {
        this.entityData.set(REVERT_FLAME_ATTACK, (Object)revertFlameAttack);
    }

    public int getRevertSpecialAttack2() {
        return (Integer)this.entityData.get(REVERT_SPECIAL_ATTACK2);
    }

    public void setRevertSpecialAttack2(int revertSpecialAttack) {
        this.entityData.set(REVERT_SPECIAL_ATTACK2, (Object)revertSpecialAttack);
    }

    public int getCounterSwitchPhase2() {
        return (Integer)this.entityData.get(COUNTER_SWITCH_PHASE_2);
    }

    public void setCounterSwitchPhase2(int counterSwitchPhase2) {
        this.entityData.set(COUNTER_SWITCH_PHASE_2, (Object)counterSwitchPhase2);
    }

    public int getCounterSwitchPhase3() {
        return (Integer)this.entityData.get(COUNTER_SWITCH_PHASE_3);
    }

    public void setCounterSwitchPhase3(int counterSwitchPhase3) {
        this.entityData.set(COUNTER_SWITCH_PHASE_3, (Object)counterSwitchPhase3);
    }

    public boolean getIsDoingSpecialAttack2() {
        return (Boolean)this.entityData.get(IS_DOING_SPECIAL_ATTACK2);
    }

    public void setIsDoingSpecialAttack2(boolean isDoingSpecialAttack) {
        this.entityData.set(IS_DOING_SPECIAL_ATTACK2, (Object)isDoingSpecialAttack);
    }

    public boolean getIsDoingSpecialAttack3() {
        return (Boolean)this.entityData.get(IS_DOING_SPECIAL_ATTACK3);
    }

    public void setIsDoingSpecialAttack3(boolean isDoingSpecialAttack) {
        this.entityData.set(IS_DOING_SPECIAL_ATTACK3, (Object)isDoingSpecialAttack);
    }

    public int getRevertSpecialAttack3() {
        return (Integer)this.entityData.get(REVERT_SPECIAL_ATTACK3);
    }

    public void setRevertSpecialAttack3(int revertSpecialAttack) {
        this.entityData.set(REVERT_SPECIAL_ATTACK3, (Object)revertSpecialAttack);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(PHASE, (Object)1);
        pBuilder.define(INVULNERABLE, (Object)true);
        pBuilder.define(SUMMON, (Object)true);
        pBuilder.define(NOMOVEMENT, (Object)true);
        pBuilder.define(SHOULD_SEARCH_TARGET, (Object)false);
        pBuilder.define(IS_DOING_FLAME_ATTACK, (Object)false);
        pBuilder.define(IS_DOING_SPECIAL_ATTACK2, (Object)false);
        pBuilder.define(IS_DOING_SPECIAL_ATTACK3, (Object)false);
        pBuilder.define(REVERT_FLAME_ATTACK, (Object)0);
        pBuilder.define(REVERT_SPECIAL_ATTACK2, (Object)0);
        pBuilder.define(REVERT_SPECIAL_ATTACK3, (Object)0);
        pBuilder.define(COUNTER_SWITCH_PHASE_2, (Object)0);
        pBuilder.define(COUNTER_SWITCH_PHASE_3, (Object)0);
    }

    public void tick() {
        super.tick();
        if (!this.initAttributes) {
            AttributeInstance attackDmg;
            AttributeInstance maxHealth = this.getAttribute(Attributes.MAX_HEALTH);
            if (maxHealth != null) {
                maxHealth.setBaseValue(KQConfigValues.NETHERMAN_HEALTH.get().doubleValue());
                this.setHealth(KQConfigValues.NETHERMAN_HEALTH.get().floatValue());
            }
            if ((attackDmg = this.getAttribute(Attributes.ATTACK_DAMAGE)) != null) {
                attackDmg.setBaseValue(KQConfigValues.NETHERMAN_DAMAGE.get().doubleValue());
            }
            this.initAttributes = true;
        }
        if (!this.level().isClientSide() && this.tickCount == 100) {
            this.setIsSummoning(false);
            this.setNoMovement(false);
            this.setInvulnerability(false);
            this.setShouldSearchTarget(true);
        }
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        if (this.isOnFire()) {
            this.extinguishFire();
        }
        if (this.getNoMovement()) {
            this.getNavigation().stop();
            this.setDeltaMovement(Vec3.ZERO);
        }
        if (this.getNoMovement()) {
            if (this.getIsDoingFlameAttack()) {
                this.setRevertFlameAttack(this.getRevertFlameAttack() + 1);
                if (this.getRevertFlameAttack() == 30) {
                    this.setNoMovement(false);
                    this.setIsDoingFlameAttack(false);
                    this.setRevertFlameAttack(0);
                }
            }
            if (this.getIsDoingSpecialAttack2()) {
                this.setRevertSpecialAttack2(this.getRevertSpecialAttack2() + 1);
                if (this.getRevertSpecialAttack2() == 30) {
                    this.setNoMovement(false);
                    this.setIsDoingSpecialAttack2(false);
                    this.setRevertSpecialAttack2(0);
                }
            }
            if (this.getIsDoingSpecialAttack3()) {
                this.setRevertSpecialAttack3(this.getRevertSpecialAttack3() + 1);
                if (this.getRevertSpecialAttack3() == 30) {
                    this.setNoMovement(false);
                    this.setIsDoingSpecialAttack3(false);
                    this.setRevertSpecialAttack3(0);
                }
            }
        }
        if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.66 && this.getPhase() != 2 && this.getPhase() != 3) {
            this.setPhase(2);
            this.setNoMovement(true);
            this.setShouldSearchTarget(false);
            this.setTarget(null);
            this.setInvulnerability(true);
        }
        if (this.getPhase() == 2 && this.getCounterSwitchPhase2() < 130) {
            this.setCounterSwitchPhase2(this.getCounterSwitchPhase2() + 1);
        }
        if (this.getCounterSwitchPhase2() == 130 && !this.hasBeenSwitchedToPhase2) {
            this.setShouldSearchTarget(true);
            this.setNoMovement(false);
            this.setInvulnerability(false);
            this.hasBeenSwitchedToPhase2 = true;
        }
        if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.33 && this.getPhase() != 3) {
            this.setPhase(3);
            this.setNoMovement(true);
            this.setShouldSearchTarget(false);
            this.setTarget(null);
            this.setInvulnerability(true);
        }
        if (this.getPhase() == 3 && this.getCounterSwitchPhase3() < 160) {
            this.setCounterSwitchPhase3(this.getCounterSwitchPhase3() + 1);
        }
        if (this.getCounterSwitchPhase3() == 160 && !this.hasBeenSwitchedToPhase3) {
            this.setShouldSearchTarget(true);
            this.setNoMovement(false);
            this.setInvulnerability(false);
            this.hasBeenSwitchedToPhase3 = true;
        }
    }

    protected void dropCustomDeathLoot(ServerLevel pLevel, DamageSource pDamageSource, boolean pRecentlyHit) {
        super.dropCustomDeathLoot(pLevel, pDamageSource, pRecentlyHit);
        this.spawnAtLocation(new ItemStack((ItemLike)KnightQuestItems.CHAOTIC_ESSENCE.get()));
        if ((double)this.getRandom().nextFloat() < 0.1) {
            this.spawnAtLocation(new ItemStack((ItemLike)KnightQuestItems.THE_ARCHITECT_OF_CHAOS_DISC.get()));
        }
    }

    private void restoreBlocks() {
        for (Map.Entry<BlockPos, BlockState> entry : this.changedBlocks.entrySet()) {
            this.level().setBlock(entry.getKey(), entry.getValue(), 3);
        }
        this.changedBlocks.clear();
    }

    public void die(@NotNull DamageSource pDamageSource) {
        super.die(pDamageSource);
        if (KQConfigValues.RESTORE_BLOCKS_POST_DEATH.get().booleanValue() && this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            this.restoreBlocks();
        }
    }

    public void saveBlockState(BlockPos pos) {
        if (!this.changedBlocks.containsKey(pos)) {
            BlockState state = this.level().getBlockState(pos);
            this.changedBlocks.put(pos, state);
        }
    }

    public boolean hurt(@NotNull DamageSource pSource, float pAmount) {
        if (this.getInvulnerability() || (pSource.is(DamageTypes.ON_FIRE) || pSource.is(DamageTypes.IN_FIRE) || pSource.is(DamageTypes.LAVA)) && this.getPhase() == 1 || pSource.is(DamageTypes.LIGHTNING_BOLT) && this.getPhase() == 3 || pSource.is(DamageTypes.EXPLOSION) || pSource.is(DamageTypes.PLAYER_EXPLOSION) || this.tickCount < 40) {
            return false;
        }
        boolean isDamaged = super.hurt(pSource, pAmount);
        if (KQConfigValues.TELEPORT_ON_HIT.get().booleanValue()) {
            this.teleport();
        }
        return isDamaged;
    }

    protected boolean teleport() {
        if (!this.level().isClientSide() && this.isAlive()) {
            double d = this.getX() + (this.random.nextDouble() - 0.5) * 40.0;
            double e = this.getY() + (double)(this.random.nextInt(64) - 32);
            double f = this.getZ() + (this.random.nextDouble() - 0.5) * 40.0;
            return this.teleport(d, e, f);
        }
        return false;
    }

    private boolean teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, y, z);
        while (mutableBlockPos.getY() > this.level().getMinBuildHeight() && !this.level().getBlockState((BlockPos)mutableBlockPos).blocksMotion()) {
            mutableBlockPos.move(Direction.DOWN);
        }
        BlockState blockState = this.level().getBlockState((BlockPos)mutableBlockPos);
        boolean bl = blockState.blocksMotion();
        boolean bl2 = blockState.getFluidState().is(FluidTags.WATER);
        if (bl && !bl2) {
            Vec3 vec3 = this.position();
            boolean bl3 = this.randomTeleport(x, y, z, true);
            if (bl3) {
                this.level().gameEvent((Holder)GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)this));
                this.level().playSound(null, this.xo, this.yo, this.zo, SoundEvents.ENDERMAN_TELEPORT, this.getSoundSource(), 1.0f, 1.0f);
                this.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
            }
            return bl3;
        }
        return false;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WARDEN_DEATH;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.level() instanceof ServerLevel && this.deathTime > 0 && this.deathTime % 10 == 0) {
            ExperienceOrb.award((ServerLevel)((ServerLevel)this.level()), (Vec3)this.position(), (int)Mth.floor((float)((float)KQConfigValues.EXPERIENCE_DROP_AMOUNT.get().intValue() * 0.08f)));
        }
        if (this.deathTime >= 80 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.tickCount = pCompound.getInt("tickCount");
        this.initAttributes = pCompound.getBoolean("initAttributes");
        if (!pCompound.contains("shouldPlaySummonAnimation")) {
            this.setIsSummoning(true);
        } else {
            this.setIsSummoning(pCompound.getBoolean("shouldPlaySummonAnimation"));
        }
        if (!pCompound.contains("shouldSearchTarget")) {
            this.setShouldSearchTarget(false);
        } else {
            this.setShouldSearchTarget(pCompound.getBoolean("shouldSearchTarget"));
        }
        if (!pCompound.contains("isInvulnerable")) {
            this.setInvulnerability(true);
        } else {
            this.setInvulnerability(pCompound.getBoolean("isInvulnerable"));
        }
        if (!pCompound.contains("isNoMovement")) {
            this.setNoMovement(true);
        } else {
            this.setNoMovement(pCompound.getBoolean("isNoMovement"));
        }
        this.setCounterSwitchPhase2(pCompound.getInt("counterSwitchPhase2"));
        this.setCounterSwitchPhase3(pCompound.getInt("counterSwitchPhase3"));
        if (!pCompound.contains("phase")) {
            this.setPhase(1);
        } else {
            this.setPhase(pCompound.getInt("phase"));
        }
        if (this.hasCustomName() && this.getDisplayName() != null) {
            this.bossInfo.setName(this.getDisplayName());
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("tickCount", this.tickCount);
        pCompound.putBoolean("shouldPlaySummonAnimation", this.getIsSummoning());
        pCompound.putBoolean("shouldSearchTarget", this.getShouldSearchTarget());
        pCompound.putBoolean("isInvulnerable", this.getInvulnerability());
        pCompound.putBoolean("isNoMovement", this.getNoMovement());
        pCompound.putInt("counterSwitchPhase2", this.getCounterSwitchPhase2());
        pCompound.putInt("counterSwitchPhase3", this.getCounterSwitchPhase3());
        pCompound.putInt("phase", this.getPhase());
        pCompound.putBoolean("initAttributes", this.initAttributes);
    }

    public void setCustomName(@Nullable Component pName) {
        super.setCustomName(pName);
        this.bossInfo.setName(this.getDisplayName());
    }

    public void startSeenByPlayer(@NotNull ServerPlayer pPlayer) {
        super.startSeenByPlayer(pPlayer);
        this.bossInfo.addPlayer(pPlayer);
    }

    public void stopSeenByPlayer(@NotNull ServerPlayer pPlayer) {
        super.stopSeenByPlayer(pPlayer);
        this.bossInfo.removePlayer(pPlayer);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "movementController", this::movementPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", this::attackPredicate));
    }

    private <E extends GeoAnimatable> PlayState movementPredicate(AnimationState<E> event) {
        if (this.isDeadOrDying()) {
            event.getController().setAnimation(this.DEATH);
        } else if (this.getIsSummoning()) {
            event.getController().setAnimation(this.SUMMONANIM);
        } else if (this.getCounterSwitchPhase3() < 160 && this.getPhase() == 3) {
            event.getController().setAnimation(this.PHASE_SWITCH_3);
        } else if (this.getCounterSwitchPhase2() < 130 && this.getPhase() == 2) {
            event.getController().setAnimation(this.PHASE_SWITCH_2);
        } else if (this.getIsDoingSpecialAttack3()) {
            event.getController().setAnimation(this.SPECIALATTACK3ANIM);
        } else if (this.getIsDoingSpecialAttack2()) {
            event.getController().setAnimation(this.SPECIALATTACK2ANIM);
        } else if (this.getIsDoingFlameAttack()) {
            event.getController().setAnimation(this.SPECIALATTACKANIM);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.WALKANIM);
        } else {
            event.getController().setAnimation(this.IDLEANIM);
        }
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState<?> event) {
        if (this.swinging && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            String attackPattern = switch (this.random.nextInt(11)) {
                case 3, 4, 5 -> "attack2";
                case 6, 7, 8 -> "attack3";
                default -> "attack";
            };
            event.getController().setAnimation(RawAnimation.begin().thenPlay(attackPattern));
            this.swinging = false;
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

