/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.client.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.xylonity.knightquest.client.entity.model.EldBombModel;
import dev.xylonity.knightquest.common.entity.entities.EldBombEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class EldBombRenderer
extends GeoEntityRenderer<EldBombEntity> {
    private static final ResourceLocation DEFAULT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"knightquest", (String)"textures/entity/eldbomb.png");
    private static final ResourceLocation WHITE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"knightquest", (String)"textures/entity/eldbomb_white.png");

    public EldBombRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new EldBombModel());
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(EldBombEntity animatable) {
        if (animatable.getSwell() > 10) {
            if (animatable.tickCount / 5 % 2 == 0) {
                return WHITE_TEXTURE;
            }
            return DEFAULT_TEXTURE;
        }
        return DEFAULT_TEXTURE;
    }

    public void render(EldBombEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.isBaby()) {
            poseStack.scale(0.4f, 0.4f, 0.4f);
        } else {
            poseStack.scale(1.1f, 1.1f, 1.1f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }
}

