/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.util;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class EntityUtil {
    public static void teleportEntity(Entity entity, BlockPos pos) {
        entity.teleportTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
    }

    public static void makeEntityFollow(Entity follower, Entity target, double speed) {
        if (follower instanceof Mob) {
            Mob mob = (Mob)follower;
            if (target != null) {
                mob.getNavigation().moveTo(target, speed);
            }
        }
    }

    public static void applyKnockbackInDirection(Entity entity, Vec3 direction, double force) {
        Vec3 vec3 = direction.normalize().scale(force);
        entity.setDeltaMovement(vec3);
        entity.hurtMarked = true;
    }

    public static void teleportToHighestSolidBlock(Entity entity, ServerLevel level) {
        BlockPos currentPos = entity.blockPosition();
        BlockPos highestPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, currentPos);
        entity.teleportTo((double)highestPos.getX() + 0.5, (double)highestPos.getY(), (double)highestPos.getZ() + 0.5);
    }

    public static void leashEntity(Entity entity, Entity leashHolder) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.setLeashedTo(leashHolder, true);
        }
    }

    public static void pullEntityTowards(Entity entity, Vec3 targetPos, double pullStrength) {
        Vec3 direction = targetPos.subtract(entity.position()).normalize();
        Vec3 pullVector = direction.scale(pullStrength);
        entity.setDeltaMovement(entity.getDeltaMovement().add(pullVector));
        entity.hurtMarked = true;
    }

    public static void launchEntityUpwards(Entity entity, double velocity) {
        entity.setDeltaMovement(new Vec3(0.0, velocity, 0.0));
        entity.hurtMarked = true;
    }

    public static void explodeEntity(Entity entity, float explosionPower, boolean destroysBlocks) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (!entity.level().isClientSide) {
                level2.explode(entity, entity.getX(), entity.getY(), entity.getZ(), explosionPower, destroysBlocks ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
                entity.remove(Entity.RemovalReason.KILLED);
            }
        }
    }

    public static void buryEntity(Entity entity, int yLevel) {
        BlockPos entityPos = entity.blockPosition();
        entity.teleportTo((double)entityPos.getX(), (double)yLevel, (double)entityPos.getZ());
    }

    public static void strikeWithLightning(Entity entity, ServerLevel level) {
        LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)level);
        lightning.moveTo(entity.getX(), entity.getY(), entity.getZ());
        level.addFreshEntity((Entity)lightning);
    }

    public static void randomTeleportWithinRadius(Entity entity, double radius) {
        double randomX = entity.getX() + (Math.random() - 0.5) * radius * 2.0;
        double randomZ = entity.getZ() + (Math.random() - 0.5) * radius * 2.0;
        double y = entity.level().getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)randomX, (int)randomZ);
        entity.teleportTo(randomX, y, randomZ);
    }

    public static boolean isEntityInCompleteDarkness(Entity entity) {
        return entity.level().getMaxLocalRawBrightness(entity.blockPosition()) == 0;
    }
}

