/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.compat.datagen;

import dev.xylonity.knightlib.compat.datagen.KnightLibAddItemModifier;
import dev.xylonity.knightlib.compat.registry.KnightLibItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class KnightLibLootModifierGenerator
extends GlobalLootModifierProvider {
    private static final ResourceLocation[] MOB_IDS;

    public KnightLibLootModifierGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, String modid) {
        super(output, registries, modid);
    }

    protected void start() {
        for (ResourceLocation mobId : MOB_IDS) {
            this.add(mobId.getPath() + "_small_essence", (IGlobalLootModifier)new KnightLibAddItemModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(mobId).build()}, new ItemStack((ItemLike)KnightLibItems.SMALL_ESSENCE.get()).getItem(), 1.0f), new ICondition[0]);
        }
    }

    static {
        int i;
        String[] vanilla = new String[]{"creeper", "spider", "skeleton", "zombie", "cave_spider", "blaze", "enderman", "ghast", "magma_cube", "phantom", "slime", "stray", "vex", "drowned", "witch", "husk", "zombie_villager", "wither_skeleton", "pillager", "vindicator", "evoker", "hoglin", "piglin"};
        String[] knightquest = new String[]{"gremlin", "eldknight", "samhain", "ratman", "swampman", "eldbomb", "lizzy", "bad_patch"};
        MOB_IDS = new ResourceLocation[vanilla.length + knightquest.length];
        for (i = 0; i < vanilla.length; ++i) {
            KnightLibLootModifierGenerator.MOB_IDS[i] = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("entities/" + vanilla[i]));
        }
        for (i = 0; i < knightquest.length; ++i) {
            KnightLibLootModifierGenerator.MOB_IDS[vanilla.length + i] = ResourceLocation.fromNamespaceAndPath((String)"knightquest", (String)("entities/" + knightquest[i]));
        }
    }

    @EventBusSubscriber(modid="knightlib", bus=EventBusSubscriber.Bus.MOD)
    public static class KnightLibRecipeGenerator {
        @SubscribeEvent
        public static void gatherData(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            PackOutput packOutput = generator.getPackOutput();
            generator.addProvider(event.includeServer(), (DataProvider)new KnightLibLootModifierGenerator(packOutput, event.getLookupProvider(), "knightlib"));
        }
    }
}

