/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.compat.datagen;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xylonity.knightlib.compat.config.values.KnightLibValues;
import dev.xylonity.knightlib.compat.registry.KnightLibItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class KnightLibAddItemModifier
extends LootModifier {
    public static final Supplier<MapCodec<KnightLibAddItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> KnightLibAddItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(KnightLibAddItemModifier::getItem)).and((App)Codec.FLOAT.fieldOf("chance").forGetter(KnightLibAddItemModifier::getChance)).apply((Applicative)inst, KnightLibAddItemModifier::new)));
    private final Item item;
    private float chance;

    public KnightLibAddItemModifier(LootItemCondition[] conditionsIn, Item item, float chance) {
        super(conditionsIn);
        this.item = item;
        this.chance = chance;
    }

    public Item getItem() {
        return this.item;
    }

    public float getChance() {
        return this.chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        if (this.item == KnightLibItems.SMALL_ESSENCE.get() && context.getRandom().nextFloat() <= KnightLibValues.DROP_CHANCE_SMALL_ESSENCE) {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

