/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.compat.block;

import dev.xylonity.knightlib.KnightLib;
import dev.xylonity.knightlib.block.AbstractTickBlock;
import dev.xylonity.knightlib.compat.integration.KnightQuestIntegration;
import dev.xylonity.knightlib.compat.registry.KnightLibBlocks;
import dev.xylonity.knightlib.compat.registry.KnightLibItems;
import dev.xylonity.knightlib.compat.registry.KnightLibParticles;
import dev.xylonity.knightquest.common.item.KQWeaponItem;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ChaliceBlock
extends AbstractTickBlock {
    public static final IntegerProperty fill = IntegerProperty.create((String)"level", (int)1, (int)10);
    private static final VoxelShape SHAPE_N = Stream.of(Block.box((double)0.0, (double)7.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), Block.box((double)14.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.box((double)2.0, (double)7.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0), Block.box((double)2.0, (double)7.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public ChaliceBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE_N;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{fill});
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack pStack, @NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHitResult) {
        double particleZ;
        double particleX;
        int i;
        double initialY;
        double centerZ;
        double centerX;
        double radius;
        Block block = pLevel.getBlockState(pPos).getBlock();
        ItemStack stack = pPlayer.getItemInHand(pHand);
        Item item = stack.getItem();
        Item knightquestEmptyGoblet = null;
        Item knightquestFilledGoblet = null;
        Item knightquestRadiantEssence = null;
        Item knightquestChaoticEssence = null;
        if (KnightLib.isKnightQuestLoaded()) {
            knightquestEmptyGoblet = KnightQuestIntegration.getEmptyGoblet();
            knightquestFilledGoblet = KnightQuestIntegration.getFilledGoblet();
            knightquestRadiantEssence = KnightQuestIntegration.getRadiantEssence();
            knightquestChaoticEssence = KnightQuestIntegration.getChaoticEssence();
        }
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag dataTag = customData.copyTag();
        if (block.equals(KnightLibBlocks.GREAT_CHALICE.get()) && item instanceof KQWeaponItem && ((Integer)pState.getValue((Property)fill)).equals(10) && !dataTag.getBoolean("Activated")) {
            if (pLevel.isClientSide()) {
                radius = 0.5;
                centerX = (double)pPos.getX() + 0.5;
                centerZ = (double)pPos.getZ() + 0.5;
                initialY = pPos.getY();
                for (i = 0; i < 720; i += 12) {
                    double angleRadians = Math.toRadians(i);
                    particleX = centerX + radius * Math.cos(angleRadians);
                    particleZ = centerZ + radius * Math.sin(angleRadians);
                    pLevel.addParticle((ParticleOptions)ParticleTypes.WARPED_SPORE, particleX, initialY + 1.0, particleZ, -0.5, 0.5, 0.5);
                }
            }
            if (!pLevel.isClientSide()) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)fill, (Comparable)Integer.valueOf(1)), 3);
                dataTag.putBoolean("Activated", true);
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)dataTag));
                pLevel.playSound(null, pPos, SoundEvents.EVOKER_PREPARE_SUMMON, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (block.equals(KnightLibBlocks.GREAT_CHALICE.get()) && item.equals(KnightLibItems.GREAT_ESSENCE.get()) && Arrays.asList(1, 2, 3, 4).contains(pState.getValue((Property)fill)) && !pLevel.isClientSide()) {
            double centerX2 = (double)pPos.getX() + 0.5;
            double centerZ2 = (double)pPos.getZ() + 0.5;
            double initialY2 = (double)pPos.getY() + 0.1;
            double particleY = initialY2 - 0.48;
            ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket((ParticleOptions)((SimpleParticleType)KnightLibParticles.STARSET_PARTICLE.get()), true, centerX2, particleY, centerZ2, 0.0f, 0.0f, 0.0f, 1.0f, 1);
            if (pLevel instanceof ServerLevel) {
                pLevel.getServer().getPlayerList().broadcast(null, centerX2, particleY, centerZ2, 50.0, pLevel.dimension(), (Packet)packet);
            }
            pLevel.playSound(null, pPos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)fill), 3);
            if (pPlayer.getItemInHand(pHand).getCount() > 1) {
                int count = stack.getCount();
                stack.setCount(--count);
            } else {
                pPlayer.setItemInHand(pHand, new ItemStack((ItemLike)ItemStack.EMPTY.getItem()));
            }
            if ((Integer)pState.getValue((Property)fill) == 4) {
                pLevel.playSound(null, pPos, SoundEvents.PLAYER_LEVELUP, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (block.equals(KnightLibBlocks.GREAT_CHALICE.get()) && item.equals(knightquestEmptyGoblet) && ((Integer)pState.getValue((Property)fill)).equals(5)) {
            if (pLevel.isClientSide()) {
                radius = 0.5;
                centerX = (double)pPos.getX() + 0.5;
                centerZ = (double)pPos.getZ() + 0.5;
                initialY = pPos.getY();
                for (i = 0; i < 360; i += 12) {
                    double angleRadians = Math.toRadians(i);
                    particleX = centerX + radius * Math.cos(angleRadians);
                    particleZ = centerZ + radius * Math.sin(angleRadians);
                    pLevel.addParticle((ParticleOptions)ParticleTypes.EFFECT, particleX, initialY + 1.0, particleZ, -0.5, 0.5, 0.5);
                }
            }
            if (!pLevel.isClientSide() && knightquestFilledGoblet != null) {
                pLevel.playSound(null, pPos, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (pPlayer.getItemInHand(pHand).getCount() > 1) {
                    int stackCount = stack.getCount();
                    stack.setCount(--stackCount);
                } else {
                    pPlayer.setItemInHand(pHand, new ItemStack((ItemLike)ItemStack.EMPTY.getItem()));
                }
                ItemEntity entity = new ItemEntity(pLevel, (double)pPos.getX() + 0.5, (double)pPos.getY() + 1.0, (double)pPos.getZ() + 0.5, knightquestFilledGoblet.getDefaultInstance());
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)fill, (Comparable)Integer.valueOf(1)), 3);
                pLevel.addFreshEntity((Entity)entity);
            }
        }
        if (block.equals(KnightLibBlocks.GREAT_CHALICE.get()) && item.equals(knightquestRadiantEssence) && ((Integer)pState.getValue((Property)fill)).equals(5) && !pLevel.isClientSide()) {
            if (pPlayer.getItemInHand(pHand).getCount() > 1) {
                int stackCount = stack.getCount();
                stack.setCount(--stackCount);
            } else {
                pPlayer.setItemInHand(pHand, new ItemStack((ItemLike)ItemStack.EMPTY.getItem()));
            }
            pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)fill), 3);
        }
        if (block.equals(KnightLibBlocks.GREAT_CHALICE.get()) && item.equals(knightquestChaoticEssence) && ((Integer)pState.getValue((Property)fill)).equals(5) && !pLevel.isClientSide()) {
            pLevel.playSound(null, pPos, SoundEvents.ALLAY_AMBIENT_WITHOUT_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (pPlayer.getItemInHand(pHand).getCount() > 1) {
                int stackCount = stack.getCount();
                stack.setCount(--stackCount);
            } else {
                pPlayer.setItemInHand(pHand, new ItemStack((ItemLike)ItemStack.EMPTY.getItem()));
            }
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)fill, (Comparable)Integer.valueOf(10)), 3);
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    public void animateTick(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        double particleZ;
        double particleX;
        double angleRadians;
        int i;
        double initialY;
        double centerZ;
        double centerX;
        double radius;
        if (((Integer)pState.getValue((Property)fill)).equals(5) && pLevel.isClientSide()) {
            radius = 0.37;
            centerX = (double)pPos.getX() + 0.5;
            centerZ = (double)pPos.getZ() + 0.5;
            initialY = (double)pPos.getY() - 0.5;
            for (i = 0; i < 360; i += 60) {
                angleRadians = Math.toRadians(i);
                particleX = centerX + radius * Math.cos(angleRadians);
                particleZ = centerZ + radius * Math.sin(angleRadians);
                pLevel.addParticle((ParticleOptions)ParticleTypes.EFFECT, particleX, initialY + 1.0, particleZ, 0.0, 0.35, 0.0);
            }
        }
        if (((Integer)pState.getValue((Property)fill)).equals(10) && pLevel.isClientSide()) {
            radius = 0.37;
            centerX = (double)pPos.getX() + 0.5;
            centerZ = (double)pPos.getZ() + 0.5;
            initialY = (double)pPos.getY() - 0.5;
            for (i = 0; i < 360; i += 60) {
                angleRadians = Math.toRadians(i);
                particleX = centerX + radius * Math.cos(angleRadians);
                particleZ = centerZ + radius * Math.sin(angleRadians);
                pLevel.addParticle((ParticleOptions)ParticleTypes.WARPED_SPORE, particleX, initialY + 1.0, particleZ, 0.0, 0.35, 0.0);
            }
        }
        super.animateTick(pState, pLevel, pPos, pRandom);
    }

    @Override
    public void tick(@NotNull BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        int tickCount = this.getTickCount(pPos);
        if (Arrays.asList(6, 7, 8, 9).contains(pState.getValue((Property)fill)) && KnightLib.isKnightQuestLoaded()) {
            if (tickCount == 0) {
                pLevel.playSound(null, pPos, SoundEvents.EVOKER_PREPARE_SUMMON, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (tickCount % 10 == 0 && (Integer)pState.getValue((Property)fill) != 9 && tickCount < 60) {
                pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)fill), 3);
                pLevel.playSound(null, pPos, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (tickCount == 60) {
                Entity entity;
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)fill, (Comparable)Integer.valueOf(1)), 3);
                LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)pLevel);
                if (lightningBolt != null) {
                    lightningBolt.moveTo((double)pPos.getX() + 0.5, (double)(pPos.getY() - 1), (double)pPos.getZ() + 0.5);
                    pLevel.addFreshEntity((Entity)lightningBolt);
                }
                if ((entity = KnightQuestIntegration.nethermanEntity().create((Level)pLevel)) != null) {
                    entity.moveTo((double)((float)pPos.getX() + 0.5f), (double)(pPos.getY() + 1), (double)((float)pPos.getZ() + 0.5f));
                    pLevel.addFreshEntity(entity);
                }
                this.resetTickCount(pPos);
            } else {
                this.incrementTickCount(pPos);
            }
            this.scheduleTick((Level)pLevel, pPos);
        }
    }
}

