/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.block;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;

public interface ITickBlockTracker {
    public static final Map<BlockPos, Block> blockTickMap = new HashMap<BlockPos, Block>();
    public static final Map<BlockPos, Integer> tickCounts = new HashMap<BlockPos, Integer>();

    default public void addTickBlock(BlockPos pos, Block block) {
        blockTickMap.put(pos, block);
        tickCounts.put(pos, 0);
    }

    default public void removeTickBlock(BlockPos pos) {
        blockTickMap.remove(pos);
        tickCounts.remove(pos);
    }

    default public int getTickCount(BlockPos pos) {
        return tickCounts.getOrDefault(pos, 0);
    }

    default public void incrementTickCount(BlockPos pos) {
        tickCounts.put(pos, this.getTickCount(pos) + 1);
    }

    default public Block getTickBlock(BlockPos pos) {
        return blockTickMap.get(pos);
    }

    default public void resetTickCount(BlockPos pos) {
        tickCounts.put(pos, 0);
    }
}

