/*
 * Decompiled with CFR 0.152.
 */
package dev.zeddevstuff.keybindspurger.mixin;

import dev.zeddevstuff.keybindspurger.Keybindspurger;
import dev.zeddevstuff.keybindspurger.LoaderSpecificUtils;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.controls.KeyBindsList;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={KeyBindsScreen.class})
public class KeyBindsScreenMixin
extends Screen {
    @Shadow
    private KeyBindsList keyBindsList;

    protected KeyBindsScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"addContents()V"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        if (this.minecraft == null) {
            return;
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"A"), this::keybindspurger$purgeAll).tooltip(Tooltip.create((Component)Component.translatable((String)"button.keybindspurger.purge_all"))).pos(0, this.minecraft.getWindow().getGuiScaledHeight() - 32).size(16, 16).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"M"), this::keybindspurger$purgeAllNonVanilla).tooltip(Tooltip.create((Component)Component.translatable((String)"button.keybindspurger.purge_non_vanilla"))).pos(0, this.minecraft.getWindow().getGuiScaledHeight() - 16).size(16, 16).build());
    }

    @Unique
    public void keybindspurger$purgeAll(Button button) {
        if (this.minecraft == null) {
            return;
        }
        for (KeyMapping keyMapping : this.minecraft.options.keyMappings) {
            LoaderSpecificUtils.clear(keyMapping);
        }
        this.keyBindsList.refreshEntries();
    }

    @Unique
    public void keybindspurger$purgeAllNonVanilla(Button button) {
        if (this.minecraft == null) {
            return;
        }
        for (KeyMapping keyMapping : this.minecraft.options.keyMappings) {
            if (Keybindspurger.VANILLA_KEYBINDS.contains(keyMapping.getName())) continue;
            LoaderSpecificUtils.clear(keyMapping);
        }
        this.keyBindsList.refreshEntries();
    }
}

