/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.keybindbundles.render;

import com.matyrobbrt.keybindbundles.KeyBindBundle;
import com.matyrobbrt.keybindbundles.KeyBindBundleManager;
import com.matyrobbrt.keybindbundles.KeyMappingUtil;
import com.matyrobbrt.keybindbundles.render.RadialMenuRenderer;
import com.mojang.blaze3d.platform.Window;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class KeybindSelectionOverlay
extends RadialMenuRenderer<KeyBindBundle.KeyEntry>
implements LayeredDraw.Layer {
    public static final KeybindSelectionOverlay INSTANCE = new KeybindSelectionOverlay();
    @Nullable
    private KeyBindBundle displayedKeybind;
    private KeyBindBundleManager.RadialKeyMapping displayedMapping;
    @Nullable
    private KeyMapping currentlyPressing;

    @Override
    public Component getTitle(KeyBindBundle.KeyEntry entry) {
        return Component.literal((String)entry.title());
    }

    @Override
    public ItemStack getIcon(KeyBindBundle.KeyEntry entry) {
        return entry.icon();
    }

    @Override
    public List<KeyBindBundle.KeyEntry> getEntries() {
        return this.displayedKeybind == null ? List.of() : this.displayedKeybind.getEntries();
    }

    @Override
    public int getCurrentlySelected() {
        return this.displayedKeybind.getBookmark();
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (this.displayedKeybind == null) {
            return;
        }
        super.render(guiGraphics, true);
    }

    public void mouseClick(double mouseX, double mouseY, int button, int action) {
        KeyMapping key;
        float centerY;
        double yDiff;
        Window window;
        float centerX;
        double xDiff;
        double distanceFromCenter;
        if (button == 0 && this.currentlyPressing != null && action == 0) {
            KeyMappingUtil.release(this.currentlyPressing);
            this.currentlyPressing = null;
        }
        if ((distanceFromCenter = Mth.length((double)(xDiff = mouseX - (double)(centerX = (float)(window = Minecraft.getInstance().getWindow()).getGuiScaledWidth() / 2.0f)), (double)(yDiff = mouseY - (double)(centerY = (float)window.getGuiScaledHeight() / 2.0f)))) < 10.0 || distanceFromCenter > 100.0) {
            return;
        }
        int selectionIndex = this.getElementUnderMouse(false);
        if (button == 1 && action == 0) {
            if (selectionIndex == this.displayedKeybind.getBookmark()) {
                this.displayedKeybind.setBookmark(-1);
            } else {
                this.displayedKeybind.setBookmark(selectionIndex);
            }
            KeyBindBundleManager.write();
        } else if (button == 0 && (key = KeyMappingUtil.getByName(this.displayedKeybind.getEntries().get(selectionIndex).key())) != null && action == 1) {
            KeyMappingUtil.press(key);
            KeyMappingUtil.click(key);
            this.currentlyPressing = key;
        }
    }

    @Nullable
    public KeyBindBundle getDisplayedKeybind() {
        return this.displayedKeybind;
    }

    @Nullable
    public KeyBindBundleManager.RadialKeyMapping getDisplayedMapping() {
        return this.displayedMapping;
    }

    public void open(KeyBindBundleManager.RadialKeyMapping mapping) {
        this.displayedKeybind = mapping.bind;
        this.displayedMapping = mapping;
    }

    public void close() {
        this.displayedKeybind = null;
        this.displayedMapping = null;
        this.clearState();
        KeyMappingUtil.restoreAll();
    }
}

