/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.keybindbundles;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.matyrobbrt.keybindbundles.KeyBindBundle;
import com.matyrobbrt.keybindbundles.KeyMappingUtil;
import com.matyrobbrt.keybindbundles.ModKeyBindBundles;
import com.matyrobbrt.keybindbundles.PriorityKeyMapping;
import com.matyrobbrt.keybindbundles.render.KeybindSelectionOverlay;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.Options;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;

public class KeyBindBundleManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Path PATH = FMLPaths.GAMEDIR.get().resolve("keybind_bundles.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static List<KeyBindBundle> keybinds;
    private static List<RadialKeyMapping> keyMappings;

    public static void load() {
        keybinds = new ArrayList<KeyBindBundle>();
        keyMappings = new ArrayList<RadialKeyMapping>();
        try (BufferedReader is2 = Files.newBufferedReader(PATH);){
            JsonArray element = (JsonArray)GSON.fromJson((Reader)is2, JsonArray.class);
            keybinds.addAll((Collection)((Pair)KeyBindBundle.LIST_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow()).getFirst());
            for (int i = 0; i < keybinds.size(); ++i) {
                keyMappings.add(keybinds.get(i).createMapping());
            }
            Options options = Minecraft.getInstance().options;
            for (int i = 0; i < options.keyMappings.length; ++i) {
                if (options.keyMappings[i] != ModKeyBindBundles.OPEN_SCREEN_MAPPING) continue;
                options.keyMappings = (KeyMapping[])ArrayUtils.insert((int)(i + 1), (Object[])options.keyMappings, (Object[])((KeyMapping[])keyMappings.toArray(KeyMapping[]::new)));
                break;
            }
        }
        catch (NoSuchFileException is2) {
        }
        catch (IOException ex) {
            LOGGER.error("Error reading file from {}: ", (Object)PATH, (Object)ex);
        }
    }

    private static KeyMapping getLastKeyMapping() {
        return keyMappings.isEmpty() ? ModKeyBindBundles.OPEN_SCREEN_MAPPING : (KeyMapping)keyMappings.getLast();
    }

    public static KeyMapping add(KeyBindBundle bind) {
        keybinds.add(bind);
        Options options = Minecraft.getInstance().options;
        KeyMapping compareKeybind = KeyBindBundleManager.getLastKeyMapping();
        RadialKeyMapping mapping = bind.createMapping();
        keyMappings.add(mapping);
        for (int i = 0; i < options.keyMappings.length; ++i) {
            if (options.keyMappings[i] != compareKeybind) continue;
            options.keyMappings = (KeyMapping[])ArrayUtils.insert((int)(i + 1), (Object[])options.keyMappings, (Object[])new KeyMapping[]{mapping});
            break;
        }
        KeyBindBundleManager.write();
        return mapping;
    }

    public static void delete(KeyBindBundle bind) {
        int idx = keybinds.indexOf(bind);
        if (idx >= 0) {
            keybinds.remove(idx);
            RadialKeyMapping map = keyMappings.remove(idx);
            if (map != null) {
                Options options = Minecraft.getInstance().options;
                options.keyMappings = (KeyMapping[])ArrayUtils.removeElement((Object[])options.keyMappings, (Object)((Object)map));
                map.kbb$unregister();
            }
            KeyBindBundleManager.write();
        }
    }

    public static void write() {
        try {
            JsonElement out = (JsonElement)KeyBindBundle.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, keybinds).getOrThrow();
            Files.writeString(PATH, (CharSequence)GSON.toJson(out), new OpenOption[0]);
        }
        catch (IOException ex) {
            LOGGER.error("Error writing to file {}: ", (Object)PATH, (Object)ex);
        }
    }

    public static List<RadialKeyMapping> getKeys() {
        return keyMappings;
    }

    public static class RadialKeyMapping
    extends PriorityKeyMapping {
        public final KeyBindBundle bind;
        private final Component name;
        private KeyMapping currentlyPressing;

        public RadialKeyMapping(String name, int keyCode, String category, KeyBindBundle bind) {
            super(name, keyCode, category);
            this.bind = bind;
            this.name = Component.translatable((String)"key.keybindbundles.bundle", (Object[])new Object[]{Component.literal((String)bind.name).withStyle(ChatFormatting.GOLD)});
        }

        public Component kbb$getNameOverride() {
            return this.name;
        }

        public void setDown(boolean value) {
            if (this.isDown()) {
                if (value) {
                    this.click();
                } else {
                    this.onRelease();
                    super.setDown(false);
                }
            } else if (!this.isDown() && value) {
                this.onClick();
                super.setDown(true);
            }
        }

        private void onClick() {
            KeyMapping key;
            KeyBindBundle.KeyEntry entry;
            if (!this.opensRadial() && (entry = this.bind.getBookmarked()) != null && (key = KeyMappingUtil.getByName(entry.key())) != null) {
                this.setAndPress(key);
                return;
            }
            if (!this.bind.getEntries().isEmpty()) {
                KeybindSelectionOverlay.INSTANCE.open(this);
                Minecraft.getInstance().mouseHandler.releaseMouse();
            }
        }

        public void setAndPress(KeyMapping mapping) {
            this.currentlyPressing = mapping;
            KeyMappingUtil.press(mapping);
            this.click();
        }

        private void click() {
            if (this.currentlyPressing != null) {
                KeyMappingUtil.click(this.currentlyPressing);
            }
        }

        private void onRelease() {
            if (this.currentlyPressing != null) {
                KeyMappingUtil.release(this.currentlyPressing);
                this.currentlyPressing = null;
            }
            if (KeybindSelectionOverlay.INSTANCE.getDisplayedMapping() == this) {
                KeybindSelectionOverlay.INSTANCE.close();
                MouseHandler mouse = Minecraft.getInstance().mouseHandler;
                if (!mouse.isMouseGrabbed() && Minecraft.getInstance().screen == null) {
                    mouse.grabMouse();
                }
            }
        }

        private boolean opensRadial() {
            return ModKeyBindBundles.OPEN_RADIAL_MENU_MAPPING.isDown();
        }

        @Override
        public int compareTo(KeyMapping map) {
            if (map == ModKeyBindBundles.OPEN_SCREEN_MAPPING || map == ModKeyBindBundles.OPEN_RADIAL_MENU_MAPPING) {
                return 1;
            }
            return super.compareTo(map);
        }
    }
}

