/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.datagen;

import com.direwolf20.justdirethings.datagen.JustDireBiomeTags;
import com.direwolf20.justdirethings.datagen.JustDireBlockStates;
import com.direwolf20.justdirethings.datagen.JustDireBlockTags;
import com.direwolf20.justdirethings.datagen.JustDireDataMaps;
import com.direwolf20.justdirethings.datagen.JustDireEntityTags;
import com.direwolf20.justdirethings.datagen.JustDireFluidTags;
import com.direwolf20.justdirethings.datagen.JustDireItemModels;
import com.direwolf20.justdirethings.datagen.JustDireItemTags;
import com.direwolf20.justdirethings.datagen.JustDireLanguageProvider;
import com.direwolf20.justdirethings.datagen.JustDireLootTables;
import com.direwolf20.justdirethings.datagen.JustDireRecipes;
import com.direwolf20.justdirethings.datagen.JustDireSounds;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="justdirethings", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new JustDireRecipes(packOutput, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(JustDireLootTables::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        JustDireBlockTags blockTags = new JustDireBlockTags(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        JustDireFluidTags fluidTags = new JustDireFluidTags(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)fluidTags);
        JustDireItemTags itemTags = new JustDireItemTags(packOutput, lookupProvider, blockTags, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)itemTags);
        JustDireDataMaps dataMaps = new JustDireDataMaps(packOutput, lookupProvider);
        generator.addProvider(event.includeServer(), (DataProvider)dataMaps);
        JustDireEntityTags entityTags = new JustDireEntityTags(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)entityTags);
        JustDireBiomeTags biomeTags = new JustDireBiomeTags(packOutput, lookupProvider, event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)biomeTags);
        generator.addProvider(event.includeClient(), (DataProvider)new JustDireBlockStates(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new JustDireItemModels(packOutput, event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new JustDireLanguageProvider(packOutput, "en_us"));
        generator.addProvider(event.includeClient(), (DataProvider)new JustDireSounds(packOutput, event.getExistingFileHelper()));
    }
}

