/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items;

import com.direwolf20.justdirethings.common.entities.CreatureCatcherEntity;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CreatureCatcher
extends Item {
    public CreatureCatcher() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.getItemInHand(pHand);
        pLevel.playSound(null, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (pLevel.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!pLevel.isClientSide) {
            CreatureCatcherEntity creatureCatcherEntity = new CreatureCatcherEntity(pLevel, (LivingEntity)pPlayer);
            creatureCatcherEntity.setItem(itemStack);
            creatureCatcherEntity.shootFromRotation((Entity)pPlayer, pPlayer.getXRot(), pPlayer.getYRot(), 0.0f, 1.5f, 1.0f);
            pLevel.addFreshEntity((Entity)creatureCatcherEntity);
        }
        if (!pPlayer.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)pLevel.isClientSide());
    }

    public static boolean hasEntity(ItemStack itemStack) {
        return itemStack.has(JustDireDataComponents.ENTITIYTYPE);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Level level = context.level();
        if (level == null) {
            return;
        }
        Mob mob = CreatureCatcherEntity.getEntityFromItemStack(stack, level);
        if (mob == null) {
            return;
        }
        tooltip.add((Component)Component.translatable((String)"justdirethings.creature").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)"").append(mob.getName()).withStyle(ChatFormatting.GREEN)));
    }
}

