/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.containers;

import com.direwolf20.justdirethings.common.blockentities.InventoryHolderBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.containers.basecontainers.BaseMachineContainer;
import com.direwolf20.justdirethings.common.containers.handlers.FilterBasicHandler;
import com.direwolf20.justdirethings.common.containers.slots.InventoryHolderSlot;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.ItemStackKey;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class InventoryHolderContainer
extends BaseMachineContainer {
    public static final ResourceLocation EMPTY_ARMOR_SLOT_HELMET = ResourceLocation.parse((String)"item/empty_armor_slot_helmet");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_CHESTPLATE = ResourceLocation.parse((String)"item/empty_armor_slot_chestplate");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_LEGGINGS = ResourceLocation.parse((String)"item/empty_armor_slot_leggings");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_BOOTS = ResourceLocation.parse((String)"item/empty_armor_slot_boots");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_SHIELD = ResourceLocation.parse((String)"item/empty_armor_slot_shield");
    static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{EMPTY_ARMOR_SLOT_BOOTS, EMPTY_ARMOR_SLOT_LEGGINGS, EMPTY_ARMOR_SLOT_CHESTPLATE, EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public InventoryHolderBE inventoryHolderBE;

    public InventoryHolderContainer(int windowId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(windowId, playerInventory, extraData.readBlockPos());
    }

    public InventoryHolderContainer(int windowId, Inventory playerInventory, BlockPos blockPos) {
        super((MenuType)Registration.InventoryHolder_Container.get(), windowId, playerInventory, blockPos);
        this.addPlayerSlots(this.player.getInventory());
        this.addArmorSlots(this.player, this.player.getInventory());
        BaseMachineBE baseMachineBE = this.baseMachineBE;
        if (baseMachineBE instanceof InventoryHolderBE) {
            InventoryHolderBE inventoryHolderBE;
            this.inventoryHolderBE = inventoryHolderBE = (InventoryHolderBE)baseMachineBE;
        }
    }

    @Override
    public void addMachineSlots() {
        this.machineHandler = this.baseMachineBE.getMachineHandler();
        this.addMachineSlotBox((IItemHandler)this.machineHandler, 0, 8, -8, 9, 18, 3, 18);
        this.addMachineSlotRange((IItemHandler)this.machineHandler, 27, 8, 50, 9, 18);
        this.addMachineArmorSlots((IItemHandler)this.machineHandler, this.player, 36, 44, -28);
    }

    public boolean stillValid(Player playerIn) {
        return InventoryHolderContainer.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.player.level(), (BlockPos)this.pos), (Player)this.player, (Block)((Block)Registration.InventoryHolder.get()));
    }

    public void sendAllItemsToMachine() {
        for (int i = this.MACHINE_SLOTS; i < this.MACHINE_SLOTS + 36 + 5; ++i) {
            this.quickMoveStack(this.player, i);
        }
    }

    public void sendAllItemsToPlayer() {
        for (int i = 0; i < this.MACHINE_SLOTS; ++i) {
            this.quickMoveStack(this.player, i);
        }
    }

    public void swapItems() {
        for (int playerSlot = this.MACHINE_SLOTS; playerSlot < this.MACHINE_SLOTS + 36 + 5; ++playerSlot) {
            Slot playerInventorySlot = (Slot)this.slots.get(playerSlot);
            ItemStack playerStack = playerInventorySlot.getItem();
            int machineSlot = playerSlot - this.MACHINE_SLOTS;
            if (machineSlot >= this.MACHINE_SLOTS) continue;
            Slot machineInventorySlot = (Slot)this.slots.get(machineSlot);
            ItemStack machineStack = machineInventorySlot.getItem();
            if (playerStack.isEmpty() && machineStack.isEmpty() || playerSlot >= 77 && playerSlot <= 80 && EnchantmentHelper.has((ItemStack)playerStack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) continue;
            ItemStack machineStackCopy = machineStack.copy();
            ItemStack playerStackCopy = playerStack.copy();
            if (!playerStack.isEmpty()) {
                machineInventorySlot.set(ItemStack.EMPTY);
                if (this.moveItemStackTo(playerStack, machineSlot, machineSlot + 1, false) && playerStack.isEmpty()) {
                    playerInventorySlot.set(machineStackCopy);
                    machineInventorySlot.setChanged();
                    playerInventorySlot.setChanged();
                    continue;
                }
                machineInventorySlot.set(machineStackCopy);
                playerInventorySlot.set(playerStackCopy);
                continue;
            }
            if (machineStack.isEmpty()) continue;
            this.moveItemStackTo(machineStack, playerSlot, playerSlot + 1, false);
        }
    }

    @Override
    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack currentStack = slot.getItem();
            if (index >= 77 && index <= 80 && EnchantmentHelper.has((ItemStack)currentStack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
                return ItemStack.EMPTY;
            }
            if (index < this.MACHINE_SLOTS && !this.moveItemStackTo(currentStack, index + this.MACHINE_SLOTS, index + this.MACHINE_SLOTS + 1, false) && !this.moveItemStackTo(currentStack, this.MACHINE_SLOTS, this.MACHINE_SLOTS + 36 + 4, true)) {
                return ItemStack.EMPTY;
            }
            if (index >= this.MACHINE_SLOTS && !this.moveToFilteredSlot(currentStack)) {
                if (this.inventoryHolderBE.filtersOnly) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(currentStack, index - this.MACHINE_SLOTS, index - this.MACHINE_SLOTS + 1, false) && !this.moveItemStackTo(currentStack, 0, this.MACHINE_SLOTS, false)) {
                    return ItemStack.EMPTY;
                }
            }
            if (currentStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (currentStack.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, currentStack);
        }
        return itemstack;
    }

    public boolean moveToFilteredSlot(ItemStack currentStack) {
        if (this.inventoryHolderBE == null) {
            return false;
        }
        ItemStackKey key = new ItemStackKey(currentStack, this.inventoryHolderBE.compareNBT);
        FilterBasicHandler filteredItems = this.inventoryHolderBE.filterBasicHandler;
        for (int i = 0; i < filteredItems.getSlots(); ++i) {
            ItemStack stack = filteredItems.getStackInSlot(i);
            if (stack.isEmpty() || !key.equals(new ItemStackKey(stack, this.inventoryHolderBE.compareNBT)) || !this.moveItemStackTo(currentStack, i, i + 1, false) || !currentStack.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        if (this.baseMachineBE != null) {
            this.baseMachineBE.markDirtyClient();
        }
    }

    @Override
    protected void addPlayerSlots(Inventory playerInventory) {
        this.addPlayerSlots(playerInventory, 8, 102);
    }

    @Override
    protected void addPlayerSlots(Inventory playerInventory, int inX, int inY) {
        this.addSlotBox((IItemHandler)new InvWrapper((Container)playerInventory), 9, inX, inY, 9, 18, 3, 18);
        this.addSlotRange((IItemHandler)new InvWrapper((Container)playerInventory), 0, inX, inY += 58, 9, 18);
    }

    protected int addMachineSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        BaseMachineBE baseMachineBE = this.baseMachineBE;
        if (baseMachineBE instanceof InventoryHolderBE) {
            InventoryHolderBE inventoryHolderBE = (InventoryHolderBE)baseMachineBE;
            for (int i = 0; i < amount; ++i) {
                this.addSlot((Slot)new InventoryHolderSlot(handler, index, x, y, inventoryHolderBE));
                x += dx;
                ++index;
            }
        }
        return index;
    }

    protected int addMachineSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addMachineSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    public void addMachineArmorSlots(IItemHandler itemHandler, final Player playerEntity, int index, int x, int y) {
        BaseMachineBE baseMachineBE = this.baseMachineBE;
        if (baseMachineBE instanceof InventoryHolderBE) {
            InventoryHolderBE inventoryHolderBE = (InventoryHolderBE)baseMachineBE;
            for (int k = 0; k < 4; ++k) {
                final EquipmentSlot equipmentslot = SLOT_IDS[k];
                this.addSlot((Slot)new InventoryHolderSlot(this, itemHandler, index + k, x + k * 18, y, inventoryHolderBE){

                    @Override
                    public int getMaxStackSize() {
                        return 1;
                    }

                    @Override
                    public boolean mayPlace(ItemStack p_39746_) {
                        return p_39746_.canEquip(equipmentslot, (LivingEntity)playerEntity);
                    }

                    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)TEXTURE_EMPTY_SLOTS[equipmentslot.getIndex()]);
                    }
                });
            }
            this.addSlot((Slot)new InventoryHolderSlot(this, itemHandler, index + 4, x + 72, y, inventoryHolderBE){

                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_ARMOR_SLOT_SHIELD);
                }
            });
        }
    }

    public void addArmorSlots(final Player playerEntity, Inventory playerInventory) {
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlot equipmentslot = SLOT_IDS[k];
            this.addSlot(new Slot(this, (Container)playerInventory, 39 - k, 44 + k * 18, 82){

                public void setByPlayer(ItemStack p_270969_, ItemStack p_299918_) {
                    InventoryHolderContainer.onEquipItem(playerEntity, equipmentslot, p_270969_, p_299918_);
                    super.setByPlayer(p_270969_, p_299918_);
                }

                public int getMaxStackSize() {
                    return 1;
                }

                public boolean mayPlace(ItemStack p_39746_) {
                    return p_39746_.canEquip(equipmentslot, (LivingEntity)playerEntity);
                }

                public boolean mayPickup(Player p_39744_) {
                    ItemStack itemstack = this.getItem();
                    return !itemstack.isEmpty() && !p_39744_.isCreative() && EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) ? false : super.mayPickup(p_39744_);
                }

                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)TEXTURE_EMPTY_SLOTS[equipmentslot.getIndex()]);
                }
            });
        }
        this.addSlot(new Slot(this, (Container)playerInventory, 40, 116, 82){

            public void setByPlayer(ItemStack p_270479_, ItemStack p_299920_) {
                InventoryHolderContainer.onEquipItem(playerEntity, EquipmentSlot.OFFHAND, p_270479_, p_299920_);
                super.setByPlayer(p_270479_, p_299920_);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
    }

    static void onEquipItem(Player pPlayer, EquipmentSlot pSlot, ItemStack pNewItem, ItemStack pOldItem) {
        pPlayer.onEquipItem(pSlot, pOldItem, pNewItem);
    }
}

