/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.containers.handlers.PlayerHandler;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.setup.Registration;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PlayerAccessorBE
extends BaseMachineBE {
    public ServerPlayer serverPlayer;
    public HashMap<Direction, PlayerHandler> playerHandlers = new HashMap();
    public HashMap<Direction, Integer> sidedInventoryTypes = new HashMap();
    boolean checkedPlayer = false;

    public PlayerAccessorBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.tickSpeed = (Integer)Config.PLAYER_ACCESSOR_VALIDATION_TIME.get();
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.canRun()) {
            this.checkedPlayer = false;
            this.validatePlayer();
        }
    }

    public void updateSidedInventory(Direction direction, int type) {
        this.sidedInventoryTypes.put(direction, type);
        this.clearCache();
        this.markDirtyClient();
    }

    public PlayerAccessorBE(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)Registration.PlayerAccessorBE.get(), pPos, pBlockState);
    }

    public void clearCache() {
        this.playerHandlers.clear();
        this.serverPlayer = null;
        if (this.level != null) {
            this.updateServerPlayer();
        }
        this.markDirtyClient();
    }

    public boolean isValidDim(ServerPlayer serverPlayer) {
        if (serverPlayer == null || serverPlayer.isRemoved()) {
            return false;
        }
        if (Config.PLAYER_ACCESSOR_DIMENSIONAL_BLACKLISTING.isFalse()) {
            return true;
        }
        List blacklist = (List)Config.PLAYER_ACCESSOR_BLACKLISTED_DIMENSIONS.get();
        return !blacklist.contains(serverPlayer.level().dimension().location().toString());
    }

    public void validatePlayer() {
        if (this.getServerPlayer() != null && (this.serverPlayer.isRemoved() || !this.isValidDim(this.serverPlayer))) {
            this.clearCache();
        }
    }

    public ServerPlayer getServerPlayer() {
        if (this.serverPlayer == null && !this.checkedPlayer) {
            this.updateServerPlayer();
        }
        return this.serverPlayer;
    }

    public void updateServerPlayer() {
        this.checkedPlayer = true;
        if (this.placedByUUID == null) {
            this.serverPlayer = null;
            return;
        }
        if (!this.isValidDim(this.level.getServer().getPlayerList().getPlayer(this.placedByUUID))) {
            this.serverPlayer = null;
            return;
        }
        if (this.serverPlayer == null || this.serverPlayer.isRemoved()) {
            boolean wasNull = this.serverPlayer == null;
            this.serverPlayer = this.level.getServer().getPlayerList().getPlayer(this.placedByUUID);
            if (wasNull && this.serverPlayer != null || !wasNull && this.serverPlayer == null) {
                this.markDirtyClient();
            }
        }
    }

    public PlayerHandler getPlayerHandler(Direction side) {
        if (this.getServerPlayer() == null) {
            return null;
        }
        if (!this.playerHandlers.containsKey(side)) {
            this.playerHandlers.put(side, new PlayerHandler((Player)this.serverPlayer, PlayerHandler.InventoryType.values()[this.sidedInventoryTypes.getOrDefault(side, 0)]));
        } else if (this.playerHandlers.get((Object)side).player.isRemoved()) {
            this.validatePlayer();
            if (this.serverPlayer == null) {
                return null;
            }
            this.playerHandlers.put(side, new PlayerHandler((Player)this.serverPlayer, PlayerHandler.InventoryType.values()[this.sidedInventoryTypes.getOrDefault(side, 0)]));
        }
        return this.playerHandlers.get(side);
    }

    @Override
    public boolean isDefaultSettings() {
        return true;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        for (Direction direction : Direction.values()) {
            tag.putInt("sidedInventory_" + direction.ordinal(), this.sidedInventoryTypes.getOrDefault(direction, 0).intValue());
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        for (Direction direction : Direction.values()) {
            this.sidedInventoryTypes.put(direction, tag.getInt("sidedInventory_" + direction.ordinal()));
        }
        super.loadAdditional(tag, provider);
    }

    @Override
    public void markDirtyClient() {
        if (this.level != null) {
            this.level.invalidateCapabilities(this.getBlockPos());
        }
        super.markDirtyClient();
    }
}

