/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens.widgets;

import com.direwolf20.justdirethings.client.screens.widgets.BaseButton;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class NumberButton
extends BaseButton {
    private int value;
    public int min;
    public int max;

    public NumberButton(int x, int y, int width, int height, int value, int min, int max, Component localization, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.value = value;
        this.localization = localization;
        this.min = min;
        this.max = max;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -13290187);
        guiGraphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.width - 1, this.getY() + this.height - 1, -2565928);
        Font font = Minecraft.getInstance().font;
        PoseStack stack = guiGraphics.pose();
        stack.pushPose();
        float scale = 0.75f;
        stack.scale(scale, scale, scale);
        String msg = String.format("%,d", this.value);
        float x = ((float)this.getX() + (float)this.width / 2.0f) / scale - (float)font.width(msg) / 2.0f;
        float f = this.getY();
        Objects.requireNonNull(font);
        float y = (f + (float)(this.height - 9) / 2.0f / scale) / scale + 1.0f;
        guiGraphics.drawString(font, msg, x, y, Color.DARK_GRAY.getRGB(), false);
        stack.popPose();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }
}

