/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.entityrenders;

import com.direwolf20.justdirethings.common.entities.CreatureCatcherEntity;
import com.direwolf20.justdirethings.setup.Registration;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CreatureCatcherEntityRender
extends ThrownItemRenderer<CreatureCatcherEntity> {
    private final ItemRenderer itemRenderer;
    private final float scale;
    private final boolean fullBright;

    public CreatureCatcherEntityRender(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.itemRenderer = pContext.getItemRenderer();
        this.scale = 1.0f;
        this.fullBright = false;
    }

    public void render(CreatureCatcherEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        if (pEntity.tickCount >= 2 || !(this.entityRenderDispatcher.camera.getEntity().distanceToSqr((Entity)pEntity) < 12.25)) {
            Vector3f originalPosition;
            float fraction;
            pPoseStack.pushPose();
            pPoseStack.scale(this.scale, this.scale, this.scale);
            pPoseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            float multiplier = 10.0f * (float)pEntity.shrinkingTime() % 360.0f;
            pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f + multiplier));
            boolean capturing = pEntity.isCapturing();
            if (!capturing && pEntity.renderTick > 0) {
                this.itemRenderer.renderStatic(new ItemStack((ItemLike)Registration.CreatureCatcher.get()), ItemDisplayContext.GROUND, pPackedLight, OverlayTexture.NO_OVERLAY, pPoseStack, pBuffer, pEntity.level(), pEntity.getId());
            } else {
                this.itemRenderer.renderStatic(pEntity.getItem(), ItemDisplayContext.GROUND, pPackedLight, OverlayTexture.NO_OVERLAY, pPoseStack, pBuffer, pEntity.level(), pEntity.getId());
            }
            pPoseStack.popPose();
            ItemStack returnStack = pEntity.getReturnStack();
            Mob mob = !capturing ? CreatureCatcherEntity.getEntityFromItemStack(pEntity.getItem(), pEntity.level()) : CreatureCatcherEntity.getEntityFromItemStack(returnStack, pEntity.level());
            if (mob == null) {
                return;
            }
            mob.yBodyRot = pEntity.getBodyRot();
            mob.yBodyRotO = pEntity.getBodyRot();
            mob.yHeadRot = pEntity.getHeadRot();
            mob.yHeadRotO = pEntity.getHeadRot();
            pPoseStack.pushPose();
            Vector3f entityPosition = new Vector3f((float)pEntity.getX(), (float)pEntity.getY() + (float)(pEntity.getBoundingBox().getYsize() / 2.0), (float)pEntity.getZ());
            int currentShrinkingTime = Math.min(pEntity.renderTick, pEntity.getAnimationTicks());
            int lastShrinkingTime = pEntity.renderTick == 0 ? 0 : pEntity.renderTick - 1;
            float interpolatedShrinkingTime = Mth.lerp((float)pPartialTicks, (float)lastShrinkingTime, (float)currentShrinkingTime);
            if (capturing) {
                fraction = interpolatedShrinkingTime / (float)pEntity.getAnimationTicks();
                originalPosition = new Vector3f((Vector3fc)pEntity.getMobPosition());
            } else {
                fraction = ((float)pEntity.getAnimationTicks() - interpolatedShrinkingTime) / (float)pEntity.getAnimationTicks();
                originalPosition = new Vector3f((Vector3fc)entityPosition);
            }
            fraction = Mth.cos((float)(fraction * (float)Math.PI)) * -0.5f + 0.5f;
            Vector3f interpolatedPosition = originalPosition.lerp((Vector3fc)entityPosition, fraction);
            pPoseStack.translate((double)interpolatedPosition.x() - pEntity.getX(), (double)interpolatedPosition.y() - pEntity.getY(), (double)interpolatedPosition.z() - pEntity.getZ());
            float bigScale = 1.0f;
            float smallScale = 0.2f;
            float scale = Mth.clampedLerp((float)bigScale, (float)smallScale, (float)fraction);
            pPoseStack.scale(scale, scale, scale);
            EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
            EntityRenderer renderer = dispatcher.getRenderer((Entity)mob);
            renderer.render((Entity)mob, mob.yBodyRot, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
            pPoseStack.popPose();
        }
    }
}

