/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import journeymap.api.services.Services;
import journeymap.common.nbt.model.PlayerDTO;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class PlayerData
extends SavedData {
    private static final Codec<PlayerDTO> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("player_id").forGetter(PlayerDTO::getUuid), (App)Codec.BOOL.fieldOf("hidden_underground").forGetter(PlayerDTO::isHiddenUnderground), (App)Codec.BOOL.fieldOf("radar_visible").forGetter(PlayerDTO::isVisible), (App)Codec.BOOL.fieldOf("view_loaded_chunk_entity").forGetter(PlayerDTO::isChunkEntity), (App)Codec.BOOL.fieldOf("view_loaded_chunk_full").forGetter(PlayerDTO::isChunkFull), (App)Codec.BOOL.fieldOf("view_loaded_chunk_block").forGetter(PlayerDTO::isChunkBlock), (App)Codec.BOOL.fieldOf("view_loaded_chunk_inaccessible").forGetter(PlayerDTO::isChunkInaccessible)).apply((Applicative)instance, PlayerDTO::new));
    private static final String DAT_FILE = "JMPlayerSettings";
    private CompoundTag data = new CompoundTag();
    Map<String, PlayerDTO> playerMap = new HashMap<String, PlayerDTO>();

    public PlayerData() {
        Services.COMMON_SERVICE.getServer().getLevel(Level.OVERWORLD).getDataStorage().set(DAT_FILE, (SavedData)this);
        this.setDirty();
    }

    public static PlayerData getPlayerData() {
        return PlayerData.get();
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        this.playerMap.forEach((uuid, player) -> {
            DataResult result = CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, player);
            if (result.result().isPresent()) {
                this.data.put(uuid, (Tag)result.result().get());
            }
        });
        compound.put(DAT_FILE, (Tag)this.data);
        return compound;
    }

    private static PlayerData get() {
        ServerLevel level = Services.COMMON_SERVICE.getServer().getLevel(Level.OVERWORLD);
        return (PlayerData)level.getDataStorage().computeIfAbsent(PlayerData.dataFactory(), DAT_FILE);
    }

    private static PlayerData load(CompoundTag nbt, HolderLookup.Provider provider) {
        PlayerData playerData = new PlayerData();
        playerData.data = nbt.getCompound(DAT_FILE);
        return playerData;
    }

    public static SavedData.Factory<PlayerData> dataFactory() {
        return new SavedData.Factory(PlayerData::load, PlayerData::load, DataFixTypes.OPTIONS);
    }

    private static PlayerData load() {
        return new PlayerData();
    }

    public PlayerDTO getPlayer(ServerPlayer serverPlayer) {
        String uuid = serverPlayer.getStringUUID();
        PlayerDTO player = this.playerMap.get(uuid);
        if (player == null) {
            CompoundTag playterTag;
            DataResult result;
            if (this.data.contains(uuid) && (result = CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)(playterTag = this.data.getCompound(uuid)))).result().isPresent()) {
                PlayerDTO playerData = (PlayerDTO)result.result().get();
                this.playerMap.put(uuid, playerData);
                return playerData;
            }
            player = new PlayerDTO(uuid);
            DataResult result2 = CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)player);
            this.data.put(uuid, (Tag)result2.result().get());
            this.playerMap.put(uuid, player);
        }
        return player;
    }
}

