/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.waypoint;

import journeymap.client.JourneymapClient;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.client.ui.component.widgets.PropertiesRadioButtonListWidget;
import journeymap.client.ui.waypointmanager.waypoint.CoordinatesLayout;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class EditorOptionsPopup
extends PopupButtonScreen<Boolean> {
    private LinearLayout layout;
    private CoordinatesLayout coordinatesLayout;

    protected EditorOptionsPopup() {
        super((Component)Component.translatable((String)"Waypoint Editor Options"));
    }

    public void repositionElements() {
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }

    public void init() {
        this.coordinatesLayout = (CoordinatesLayout)((Object)JourneymapClient.getInstance().getWaypointProperties().coordinatesFormat.get());
        Font font = Minecraft.getInstance().font;
        this.layout = LinearLayout.vertical();
        LinearLayout contentLayout = LinearLayout.horizontal();
        LinearLayout bottomRowLayout = LinearLayout.horizontal();
        this.layout.spacing(6);
        this.layout.addChild((LayoutElement)contentLayout, LayoutSettings::alignHorizontallyCenter);
        this.layout.addChild((LayoutElement)bottomRowLayout, LayoutSettings::alignHorizontallyCenter);
        contentLayout.spacing(8);
        contentLayout.addChild(new PropertiesRadioButtonListWidget<CoordinatesLayout>("jm.waypoint.editor.coord_layout", JourneymapClient.getInstance().getWaypointProperties().coordinatesFormat, this::onLayoutChange));
        bottomRowLayout.spacing(1);
        bottomRowLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.waypoint.save"), b -> this.exit(false)).width(this.font.width((FormattedText)CommonComponents.GUI_CONTINUE) + 10).build());
        bottomRowLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, b -> this.exit(true)).width(this.font.width((FormattedText)CommonComponents.GUI_CANCEL) + 10).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    private void onLayoutChange(CoordinatesLayout updatedLayout) {
        this.coordinatesLayout = updatedLayout;
    }

    public void renderPopupScreenBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blitSprite(BACKGROUND_SPRITE, this.layout.getX() - 18, this.layout.getY() - 18, this.layout.getWidth() + 36, this.layout.getHeight() + 36);
    }

    private void exit(boolean canceled) {
        if (!canceled) {
            JourneymapClient.getInstance().getWaypointProperties().coordinatesFormat.set(this.coordinatesLayout);
            this.setResponseAndClose(true);
        } else {
            this.setResponseAndClose(false);
        }
    }
}

